/*
 * Decompiled with CFR 0.152.
 */
package de.informaticum.xjc.plugins;

import com.sun.codemodel.JAnnotatable;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocCommentable;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JOp;
import com.sun.codemodel.JPrimitiveType;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.CustomizableOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import de.informaticum.xjc.api.CommandLineArgument;
import de.informaticum.xjc.api.XjcOption;
import de.informaticum.xjc.plugins.AdoptAnnotationsPlugin;
import de.informaticum.xjc.plugins.i18n.BoilerplatePluginMessages;
import de.informaticum.xjc.util.CodeModelAnalysis;
import de.informaticum.xjc.util.CodeRetrofit;
import de.informaticum.xjc.util.OutlineAnalysis;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import org.assertj.core.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BoilerplatePlugin
extends AdoptAnnotationsPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(BoilerplatePlugin.class);
    protected static final String GENERATE_METHOD = "Generate method [{}#{}].";
    protected static final String SKIP_METHOD = "Skip creation of method [{}#{}] because {}.";
    protected static final String BECAUSE_METHOD_ALREADY_EXISTS = "such method already exists";
    private static final String equals = "equals";
    private static final String EQUALS_SIGNATURE = String.format("#%s(Object)", "equals");
    private static final String hashCode = "hashCode";
    private static final String HASHCODE_SIGNATURE = String.format("#%s()", "hashCode");
    private static final String toString = "toString";
    private static final String TOSTRING_SIGNATURE = String.format("#%s()", "toString");
    private static final String OPTION_NAME = "informaticum-xjc-boilerplate";
    private static final CommandLineArgument GENERATE_EQUALS = new CommandLineArgument("boilerplate-equals", BoilerplatePluginMessages.GENERATE_EQUALS_DESCRIPTION.format(EQUALS_SIGNATURE, "-boilerplate-hashCode"), new String[0]);
    private static final CommandLineArgument GENERATE_HASHCODE = new CommandLineArgument("boilerplate-hashCode", BoilerplatePluginMessages.GENERATE_HASHCODE_DESCRIPTION.format(HASHCODE_SIGNATURE, "-boilerplate-equals"), new String[0]);
    private static final CommandLineArgument GENERATE_TOSTRING = new CommandLineArgument("boilerplate-toString", BoilerplatePluginMessages.GENERATE_TOSTRING_DESCRIPTION.format(TOSTRING_SIGNATURE), new String[0]);

    @Override
    public final Map.Entry<String, String> getOptionEntry() {
        return new AbstractMap.SimpleImmutableEntry<String, String>(OPTION_NAME, BoilerplatePluginMessages.OPTION_DESCRIPTION.text());
    }

    @Override
    public final List<XjcOption> getPluginArguments() {
        return Arrays.asList(GENERATE_EQUALS, GENERATE_HASHCODE, GENERATE_TOSTRING);
    }

    @Override
    public final boolean prepareRun() {
        GENERATE_EQUALS.activates(GENERATE_HASHCODE);
        GENERATE_HASHCODE.activates(GENERATE_EQUALS);
        return true;
    }

    @Override
    protected final boolean runClass(ClassOutline clazz) {
        GENERATE_EQUALS.doOnActivation(this::generateEquals, clazz);
        GENERATE_HASHCODE.doOnActivation(this::generateHashCode, clazz);
        GENERATE_TOSTRING.doOnActivation(this::generateToString, clazz);
        return true;
    }

    private final void generateEquals(ClassOutline clazz) {
        Collection<JFieldVar> $fields;
        Optional<JMethod> $lookup = OutlineAnalysis.getMethod(clazz, equals, Object.class);
        if ($lookup.isPresent()) {
            LOG.warn(SKIP_METHOD, new Object[]{OutlineAnalysis.fullNameOf((CustomizableOutline)clazz), EQUALS_SIGNATURE, BECAUSE_METHOD_ALREADY_EXISTS});
            return;
        }
        Assertions.assertThat($lookup).isNotPresent();
        LOG.info(GENERATE_METHOD, (Object)OutlineAnalysis.fullNameOf((CustomizableOutline)clazz), (Object)EQUALS_SIGNATURE);
        JDefinedClass $ImplClass = clazz.getImplClass();
        JMethod $equals = $ImplClass.method(1, Boolean.TYPE, equals);
        JClass $Object = this.reference(Object.class);
        JVar $other = $equals.param(8, (JType)$Object, "other");
        $equals.annotate(Override.class);
        this.hijackGeneratedAnnotation((JAnnotatable)$ImplClass, (JAnnotatable)$equals, BoilerplatePlugin.class, BoilerplatePluginMessages.EQUALS_COMMENT.format($other.name()));
        CodeRetrofit.javadocSection((JDocCommentable)$equals).append((Object)BoilerplatePluginMessages.EQUALS_IMPLNOTE.format($other.name()));
        $equals.body()._if($other.eq(CodeModelAnalysis.$null))._then()._return(JExpr.lit((boolean)false));
        $equals.body()._if(CodeModelAnalysis.$this.eq((JExpression)$other))._then()._return(JExpr.lit((boolean)true));
        $equals.body()._if(JOp.not((JExpression)CodeModelAnalysis.$this.invoke("getClass").invoke(equals).arg((JExpression)$other.invoke("getClass"))))._then()._return(JExpr.lit((boolean)false));
        JClass $Arrays = this.reference(Arrays.class);
        JClass $Objects = this.reference(Objects.class);
        ArrayList<Object> $comparisons = new ArrayList<Object>();
        if (clazz.getSuperClass() != null) {
            $comparisons.add(CodeModelAnalysis.$super.invoke(equals).arg((JExpression)$other));
        }
        if (!($fields = OutlineAnalysis.generatedPropertiesOf(clazz).values()).isEmpty()) {
            JVar $that = $equals.body().decl(8, (JType)$ImplClass, "that", (JExpression)JExpr.cast((JType)$ImplClass, (JExpression)$other));
            for (JFieldVar $field : $fields) {
                if ($field.type().isPrimitive()) {
                    $comparisons.add(CodeModelAnalysis.$this.ref((JVar)$field).eq((JExpression)$that.ref((JVar)$field)));
                    continue;
                }
                if ($field.type().isArray() && $field.type().elementType().isPrimitive()) {
                    $comparisons.add($Arrays.staticInvoke(equals).arg((JExpression)CodeModelAnalysis.$this.ref((JVar)$field)).arg((JExpression)$that.ref((JVar)$field)));
                    continue;
                }
                if ($field.type().isArray()) {
                    Assertions.assertThat((boolean)$field.type().elementType().isPrimitive()).isFalse();
                    $comparisons.add($Arrays.staticInvoke("deepEquals").arg((JExpression)CodeModelAnalysis.$this.ref((JVar)$field)).arg((JExpression)$that.ref((JVar)$field)));
                    continue;
                }
                $comparisons.add($Objects.staticInvoke(equals).arg((JExpression)CodeModelAnalysis.$this.ref((JVar)$field)).arg((JExpression)$that.ref((JVar)$field)));
            }
        }
        $equals.body()._return($comparisons.stream().reduce(JExpression::cand).orElseGet(() -> JExpr.lit((boolean)true)));
    }

    private final void generateHashCode(ClassOutline clazz) {
        Optional<JMethod> $lookup = OutlineAnalysis.getMethod(clazz, hashCode);
        if ($lookup.isPresent()) {
            LOG.warn(SKIP_METHOD, new Object[]{OutlineAnalysis.fullNameOf((CustomizableOutline)clazz), HASHCODE_SIGNATURE, BECAUSE_METHOD_ALREADY_EXISTS});
            return;
        }
        Assertions.assertThat($lookup).isNotPresent();
        LOG.info(GENERATE_METHOD, (Object)OutlineAnalysis.fullNameOf((CustomizableOutline)clazz), (Object)HASHCODE_SIGNATURE);
        JDefinedClass $ImplClass = clazz.getImplClass();
        JMethod $hashCode = $ImplClass.method(1, Integer.TYPE, hashCode);
        $hashCode.annotate(Override.class);
        this.hijackGeneratedAnnotation((JAnnotatable)$ImplClass, (JAnnotatable)$hashCode, BoilerplatePlugin.class, BoilerplatePluginMessages.HASHCODE_COMMENT.text());
        CodeRetrofit.javadocSection((JDocCommentable)$hashCode).append((Object)BoilerplatePluginMessages.HASHCODE_IMPLNOTE.text());
        JPrimitiveType $int = this.codeModel().INT;
        JClass $Object = this.reference(Object.class);
        JClass $Arrays = this.reference(Arrays.class);
        JClass $Objects = this.reference(Objects.class);
        JInvocation $straightHashFields = JExpr._new((JClass)$Object.array());
        JInvocation $hashCodeArgs = JExpr._new((JClass)$int.array());
        if (clazz.getSuperClass() != null) {
            $hashCodeArgs.arg((JExpression)CodeModelAnalysis.$super.invoke(hashCode));
        }
        for (JFieldVar $field : OutlineAnalysis.generatedPropertiesOf(clazz).values()) {
            if ($field.type().isPrimitive()) {
                $hashCodeArgs.arg((JExpression)$field.type().boxify().staticInvoke(hashCode).arg((JExpression)CodeModelAnalysis.$this.ref((JVar)$field)));
                continue;
            }
            if ($field.type().isArray() && $field.type().elementType().isPrimitive()) {
                $hashCodeArgs.arg((JExpression)$Arrays.staticInvoke(hashCode).arg((JExpression)CodeModelAnalysis.$this.ref((JVar)$field)));
                continue;
            }
            if ($field.type().isArray()) {
                Assertions.assertThat((boolean)$field.type().elementType().isPrimitive()).isFalse();
                $hashCodeArgs.arg((JExpression)$Arrays.staticInvoke("deepHashCode").arg((JExpression)CodeModelAnalysis.$this.ref((JVar)$field)));
                continue;
            }
            $straightHashFields.arg((JExpression)CodeModelAnalysis.$this.ref((JVar)$field));
        }
        if ($straightHashFields.listArgs().length > 0) {
            $hashCodeArgs.arg((JExpression)$Objects.staticInvoke("hash").arg((JExpression)$straightHashFields));
        }
        if ($hashCodeArgs.listArgs().length == 0) {
            $hashCode.body()._return((JExpression)CodeModelAnalysis.$this.invoke("getClass").invoke(hashCode));
        } else if ($hashCodeArgs.listArgs().length == 1) {
            $hashCode.body()._return($hashCodeArgs.listArgs()[0]);
        } else {
            $hashCode.body()._return((JExpression)$Arrays.staticInvoke(hashCode).arg((JExpression)$hashCodeArgs));
        }
    }

    private final void generateToString(ClassOutline clazz) {
        Optional<JMethod> $lookup = OutlineAnalysis.getMethod(clazz, toString);
        if ($lookup.isPresent()) {
            LOG.warn(SKIP_METHOD, new Object[]{OutlineAnalysis.fullNameOf((CustomizableOutline)clazz), TOSTRING_SIGNATURE, BECAUSE_METHOD_ALREADY_EXISTS});
            return;
        }
        Assertions.assertThat($lookup).isNotPresent();
        LOG.info(GENERATE_METHOD, (Object)OutlineAnalysis.fullNameOf((CustomizableOutline)clazz), (Object)TOSTRING_SIGNATURE);
        JDefinedClass $ImplClass = clazz.getImplClass();
        JMethod $toString = $ImplClass.method(1, String.class, toString);
        $toString.annotate(Override.class);
        this.hijackGeneratedAnnotation((JAnnotatable)$ImplClass, (JAnnotatable)$toString, BoilerplatePlugin.class, BoilerplatePluginMessages.TOSTRING_COMMENT.text());
        CodeRetrofit.javadocSection((JDocCommentable)$toString).append((Object)BoilerplatePluginMessages.TOSTRING_IMPLNOTE.text());
        JClass $Arrays = this.reference(Arrays.class);
        JClass $Objects = this.reference(Objects.class);
        JClass $StringJoiner = this.reference(StringJoiner.class);
        JInvocation $pieces = JExpr._new((JClass)$StringJoiner).arg(", ").arg($ImplClass.name() + "[").arg("]");
        for (Map.Entry<FieldOutline, JFieldVar> property : OutlineAnalysis.generatedPropertiesOf(clazz).entrySet()) {
            FieldOutline field = property.getKey();
            String name = field.getPropertyInfo().getName(true);
            JFieldVar $field = property.getValue();
            if ($field.type().isPrimitive()) {
                $pieces = $pieces.invoke("add").arg(JExpr.lit((String)(name + ": ")).plus((JExpression)$field.type().boxify().staticInvoke(toString).arg((JExpression)CodeModelAnalysis.$this.ref((JVar)$field))));
                continue;
            }
            if ($field.type().isArray() && $field.type().elementType().isPrimitive()) {
                $pieces = $pieces.invoke("add").arg(JExpr.lit((String)(name + ": ")).plus((JExpression)$Arrays.staticInvoke(toString).arg((JExpression)CodeModelAnalysis.$this.ref((JVar)$field))));
                continue;
            }
            if ($field.type().isArray()) {
                Assertions.assertThat((boolean)$field.type().elementType().isPrimitive()).isFalse();
                $pieces = $pieces.invoke("add").arg(JExpr.lit((String)(name + ": ")).plus((JExpression)$Arrays.staticInvoke("deepToString").arg((JExpression)CodeModelAnalysis.$this.ref((JVar)$field))));
                continue;
            }
            $pieces = $pieces.invoke("add").arg(JExpr.lit((String)(name + ": ")).plus((JExpression)$Objects.staticInvoke(toString).arg((JExpression)CodeModelAnalysis.$this.ref((JVar)$field))));
        }
        if (clazz.getSuperClass() != null) {
            $pieces = $pieces.invoke("add").arg(JExpr.lit((String)"Super: ").plus((JExpression)CodeModelAnalysis.$super.invoke(toString)));
        }
        $toString.body()._return((JExpression)$pieces.invoke(toString));
    }
}

