/*
 * Decompiled with CFR 0.152.
 */
package de.informaticum.xjc.plugins;

import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JDocCommentable;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JGenerable;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JOp;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.outline.CustomizableOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import de.informaticum.xjc.api.CommandLineArgument;
import de.informaticum.xjc.api.XjcOption;
import de.informaticum.xjc.plugins.AdoptAnnotationsPlugin;
import de.informaticum.xjc.plugins.i18n.AssignmentPluginMessages;
import de.informaticum.xjc.util.CodeModelAnalysis;
import de.informaticum.xjc.util.CodeRetrofit;
import de.informaticum.xjc.util.OutlineAnalysis;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;

public abstract class AssignmentPlugin
extends AdoptAnnotationsPlugin {
    protected static final CommandLineArgument NOTNULL_COLLECTIONS = new CommandLineArgument("general-initialise-collections", AssignmentPluginMessages.NOTNULL_COLLECTIONS_DESCRIPTION.text(), new String[0]);
    protected static final CommandLineArgument UNMODIFIABLE_COLLECTIONS = new CommandLineArgument("general-unmodifiable-collections", AssignmentPluginMessages.UNMODIFIABLE_COLLECTIONS_DESCRIPTION.text(), new String[0]);
    protected static final CommandLineArgument DEFENSIVE_COPIES = new CommandLineArgument("general-defensive-copies", AssignmentPluginMessages.DEFENSIVE_COPIES_DESCRIPTION.text(), new String[0]);
    protected static final CommandLineArgument PECS_PARAMETERS = new CommandLineArgument("general-pecs-parameters", AssignmentPluginMessages.PECS_PARAMETERS_DESCRIPTION.format(DEFENSIVE_COPIES), new String[0]);

    @Override
    public List<XjcOption> getPluginArguments() {
        return Arrays.asList(PECS_PARAMETERS, NOTNULL_COLLECTIONS, DEFENSIVE_COPIES, UNMODIFIABLE_COLLECTIONS);
    }

    @Override
    protected boolean prepareRun() {
        PECS_PARAMETERS.activates(DEFENSIVE_COPIES);
        return true;
    }

    public static final JType parameterTypeOf(JType $type) {
        return PECS_PARAMETERS.isActivated() ? CodeModelAnalysis.pecsProducerTypeOf($type) : $type;
    }

    public static final JType parameterTypeOf(JVar $var) {
        return AssignmentPlugin.parameterTypeOf($var.type());
    }

    public static final JType[] parameterTypesOf(Collection<? extends JVar> $types) {
        return (JType[])$types.stream().map(AssignmentPlugin::parameterTypeOf).toArray(JType[]::new);
    }

    protected static final Optional<JExpression> defaultExpressionFor(FieldOutline field) {
        return OutlineAnalysis.defaultExpressionFor(field, NOTNULL_COLLECTIONS.isActivated(), UNMODIFIABLE_COLLECTIONS.isActivated());
    }

    protected static final JExpression effectiveExpressionForNonNull(JType $type, JExpression $expression) {
        return DEFENSIVE_COPIES.isActivated() ? CodeModelAnalysis.cloneExpressionFor($type, $expression, UNMODIFIABLE_COLLECTIONS.isActivated()).orElse($expression) : $expression;
    }

    protected static final void accordingInitialisationAndJavadoc(Map<? extends FieldOutline, ? extends JFieldVar> properties, JMethod $setter) {
        CodeRetrofit.javadocSection((JDocCommentable)$setter).append((Object)AssignmentPluginMessages.INITIALISATION_BEGIN.text());
        for (Map.Entry<? extends FieldOutline, ? extends JFieldVar> property : properties.entrySet()) {
            FieldOutline field = property.getKey();
            JFieldVar $field = property.getValue();
            JExpression $value = AssignmentPlugin.defaultExpressionFor(field).orElse(CodeModelAnalysis.$null);
            $setter.body().assign((JAssignmentTarget)CodeModelAnalysis.$this.ref((JVar)$field), $value);
            CodeRetrofit.javadocBreak((JDocCommentable)$setter).append((Object)AssignmentPluginMessages.FIELD_INITIALISATION.format(OutlineAnalysis.javadocNameOf((CustomizableOutline)field.parent()), CodeModelAnalysis.javadocNameOf((JVar)$field), CodeModelAnalysis.render((JGenerable)$value)));
        }
        CodeRetrofit.javadocBreak((JDocCommentable)$setter).append((Object)AssignmentPluginMessages.INITIALISATION_END.text());
    }

    protected static final void accordingAssignmentAndJavadoc(Map.Entry<? extends FieldOutline, ? extends JFieldVar> property, JMethod $setter, JExpression $expression) {
        Optional<JExpression> $default = AssignmentPlugin.defaultExpressionFor(property.getKey());
        JExpression $nonNull = AssignmentPlugin.effectiveExpressionForNonNull(property.getValue().type(), $expression);
        AssignmentPlugin.accordingAssignmentAndJavadoc(property, $setter, $expression, $default, $nonNull);
    }

    protected static final void accordingAssignmentAndJavadoc(Map.Entry<? extends FieldOutline, ? extends JFieldVar> property, JMethod $setter, JExpression $expression, Optional<? extends JExpression> $default, JExpression $nonNull) {
        AssignmentPlugin.accordingAssignment(property, $setter, $expression, $default, $nonNull);
        AssignmentPlugin.accordingAssignmentJavadoc(property, $setter, $default);
    }

    protected static final void accordingAssignment(Map.Entry<? extends FieldOutline, ? extends JFieldVar> property, JMethod $setter, JExpression $expression, Optional<? extends JExpression> $default, JExpression $nonNull) {
        FieldOutline field = property.getKey();
        JFieldVar $field = property.getValue();
        if ($field.type().isPrimitive()) {
            $setter.body().assign((JAssignmentTarget)CodeModelAnalysis.$this.ref((JVar)$field), $expression);
        } else if ($default.isPresent()) {
            if (CodeModelAnalysis.render((JGenerable)$expression).equals(CodeModelAnalysis.render((JGenerable)CodeModelAnalysis.$null))) {
                $setter.body().assign((JAssignmentTarget)CodeModelAnalysis.$this.ref((JVar)$field), $default.get());
            } else {
                $setter.body().assign((JAssignmentTarget)CodeModelAnalysis.$this.ref((JVar)$field), JOp.cond((JExpression)$expression.eq(CodeModelAnalysis.$null), (JExpression)$default.get(), (JExpression)$nonNull));
            }
        } else if (OutlineAnalysis.isRequired(field)) {
            Assertions.assertThat($default).isNotPresent();
            Assertions.assertThat((String)CodeModelAnalysis.render((JGenerable)$expression)).isNotEqualTo((Object)CodeModelAnalysis.render((JGenerable)CodeModelAnalysis.$null));
            JClass $IllegalArgumentException = field.parent().parent().getCodeModel().ref(IllegalArgumentException.class);
            $setter._throws($IllegalArgumentException);
            Assertions.assertThat((boolean)CodeModelAnalysis.doesThrow($setter, $IllegalArgumentException)).isTrue();
            JConditional $condition = $setter.body()._if($expression.eq(CodeModelAnalysis.$null));
            $condition._then()._throw((JExpression)JExpr._new((JClass)$IllegalArgumentException).arg(JExpr.lit((String)("Required field '" + $field.name() + "' cannot be assigned to null!"))));
            $condition._else().assign((JAssignmentTarget)CodeModelAnalysis.$this.ref((JVar)$field), $nonNull);
        } else {
            Assertions.assertThat($default).isNotPresent();
            Assertions.assertThat((boolean)OutlineAnalysis.isOptional(field)).isTrue();
            if (CodeModelAnalysis.render((JGenerable)$expression).equals(CodeModelAnalysis.render((JGenerable)CodeModelAnalysis.$null))) {
                $setter.body().assign((JAssignmentTarget)CodeModelAnalysis.$this.ref((JVar)$field), CodeModelAnalysis.$null);
            } else if (CodeModelAnalysis.render((JGenerable)$expression).equals(CodeModelAnalysis.render((JGenerable)$nonNull))) {
                $setter.body().assign((JAssignmentTarget)CodeModelAnalysis.$this.ref((JVar)$field), $nonNull);
            } else {
                $setter.body().assign((JAssignmentTarget)CodeModelAnalysis.$this.ref((JVar)$field), JOp.cond((JExpression)$expression.eq(CodeModelAnalysis.$null), (JExpression)CodeModelAnalysis.$null, (JExpression)$nonNull));
            }
        }
    }

    private static final void accordingAssignmentJavadoc(Map.Entry<? extends FieldOutline, ? extends JFieldVar> property, JMethod $setter, Optional<? extends JExpression> $default) {
        String javadoc;
        FieldOutline field = property.getKey();
        JFieldVar $field = property.getValue();
        if ($field.type().isPrimitive()) {
            javadoc = AssignmentPluginMessages.PRIMITVE_FIELD.format(OutlineAnalysis.javadocNameOf((CustomizableOutline)field.parent()), CodeModelAnalysis.javadocNameOf((JVar)$field));
        } else if ($default.isPresent()) {
            javadoc = AssignmentPluginMessages.DEFAULTED_FIELD.format(OutlineAnalysis.javadocNameOf((CustomizableOutline)field.parent()), CodeModelAnalysis.javadocNameOf((JVar)$field), CodeModelAnalysis.render((JGenerable)$default.get()));
        } else if (OutlineAnalysis.isRequired(field)) {
            Assertions.assertThat($default).isNotPresent();
            javadoc = AssignmentPluginMessages.REQUIRED_FIELD.format(OutlineAnalysis.javadocNameOf((CustomizableOutline)field.parent()), CodeModelAnalysis.javadocNameOf((JVar)$field));
            JClass $IllegalArgumentException = field.parent().parent().getCodeModel().ref(IllegalArgumentException.class);
            Assertions.assertThat((boolean)CodeModelAnalysis.doesThrow($setter, $IllegalArgumentException)).isTrue();
            if (!$setter.javadoc().addThrows($IllegalArgumentException).contains((Object)AssignmentPluginMessages.ILLEGAL_ARGUMENT.text())) {
                CodeRetrofit.javadocSection($setter.javadoc().addThrows($IllegalArgumentException)).append((Object)AssignmentPluginMessages.ILLEGAL_ARGUMENT.text());
            }
        } else {
            Assertions.assertThat($default).isNotPresent();
            Assertions.assertThat((boolean)OutlineAnalysis.isOptional(field)).isTrue();
            javadoc = AssignmentPluginMessages.OPTIONAL_FIELD.format(OutlineAnalysis.javadocNameOf((CustomizableOutline)field.parent()), CodeModelAnalysis.javadocNameOf((JVar)$field));
        }
        CodeRetrofit.javadocSection($setter.javadoc().addParam((JVar)$field)).append((Object)javadoc);
    }

    protected static final Map<FieldOutline, JFieldVar> filterIllegalArgumentExceptionCandidates(Map<? extends FieldOutline, ? extends JFieldVar> properties, boolean enableDefault) {
        LinkedHashMap<FieldOutline, JFieldVar> candidates = new LinkedHashMap<FieldOutline, JFieldVar>();
        for (Map.Entry<? extends FieldOutline, ? extends JFieldVar> property : properties.entrySet()) {
            Optional<Object> $default;
            FieldOutline field = property.getKey();
            JFieldVar $field = property.getValue();
            Optional<Object> optional = $default = enableDefault ? AssignmentPlugin.defaultExpressionFor(field) : Optional.empty();
            if ($field.type().isPrimitive() || $default.isPresent()) continue;
            if (OutlineAnalysis.isRequired(field)) {
                Assertions.assertThat($default).isNotPresent();
                candidates.put(field, $field);
                continue;
            }
            Assertions.assertThat($default).isNotPresent();
            Assertions.assertThat((boolean)OutlineAnalysis.isOptional(field)).isTrue();
        }
        return candidates;
    }
}

