/*
 * Decompiled with CFR 0.152.
 */
package de.informaticum.xjc.plugins;

import com.sun.codemodel.JAnnotatable;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JAnnotationValue;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JGenerable;
import com.sun.codemodel.JType;
import de.informaticum.xjc.api.BasePlugin;
import de.informaticum.xjc.api.CommandLineArgument;
import de.informaticum.xjc.api.XjcOption;
import de.informaticum.xjc.util.CodeModelAnalysis;
import de.informaticum.xjc.util.CodeRetrofit;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public abstract class AdoptAnnotationsPlugin
extends BasePlugin {
    private static final String JAVAX_ANNOTATION_GENERATED = "javax.annotation.Generated";
    protected static final CommandLineArgument ADOPT_GENERATED = new CommandLineArgument("mark-generated", "mark the generated code as @javax.annotation.Generated", new String[0]);
    protected static final CommandLineArgument ADOPT_GENERATED_NODATE = new CommandLineArgument("noDate", "do not add date", new String[0]);
    protected static final CommandLineArgument ADOPT_GENERATED_CLASS = new CommandLineArgument("Xann", "generate <annotation> instead of @javax.annotation.Generated", "annotation");
    private static final String TIMESTAMP = ZonedDateTime.now().withNano(0).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);

    @Override
    public List<XjcOption> getCadgerArguments() {
        return Arrays.asList(ADOPT_GENERATED, ADOPT_GENERATED_NODATE, ADOPT_GENERATED_CLASS);
    }

    protected final Optional<JAnnotationUse> appendGeneratedAnnotation(JAnnotatable $template, JAnnotatable $target, String comment) {
        return ADOPT_GENERATED.doOnActivation(() -> this.getOrCopyOrAttachAnnotation($template, $target, comment)).map($a -> AdoptAnnotationsPlugin.setDateIfMissing($a)).map($a -> AdoptAnnotationsPlugin.appendComment($a, comment));
    }

    protected final Optional<JAnnotationUse> hijackGeneratedAnnotation(JAnnotatable $template, JAnnotatable $target, Class<?> driver, String comment) {
        return ADOPT_GENERATED.doOnActivation(() -> this.getOrCopyOrAttachAnnotation($template, $target, comment)).map($a -> AdoptAnnotationsPlugin.setDriver($a, driver)).map($a -> AdoptAnnotationsPlugin.setDateIfMissing($a)).map($a -> AdoptAnnotationsPlugin.setComment($a, comment));
    }

    private final JAnnotationUse getOrCopyOrAttachAnnotation(JAnnotatable $template, JAnnotatable $target, String comment) {
        String annotationClassName = Optional.ofNullable(ADOPT_GENERATED_CLASS.getParameterValues().get(0)).orElse(JAVAX_ANNOTATION_GENERATED);
        JClass $annotationClass = this.reference(annotationClassName);
        return $target.annotations().stream().filter($a -> $a.getAnnotationClass().compareTo((JType)$annotationClass) == 0).findFirst().orElseGet(() -> $template.annotations().stream().filter($a -> $a.getAnnotationClass().compareTo((JType)$annotationClass) == 0).findFirst().map($a -> CodeRetrofit.copyAnnotation($a, $target)).orElseGet(() -> $target.annotate($annotationClass)));
    }

    private static final JAnnotationUse setDriver(JAnnotationUse $annotation, Class<?> driver) {
        return $annotation.param("value", driver.getName());
    }

    private static final JAnnotationUse setDateIfMissing(JAnnotationUse $annotation) {
        return !ADOPT_GENERATED_NODATE.isActivated() && $annotation.getAnnotationMembers().get("date") == null ? $annotation.param("date", TIMESTAMP) : $annotation;
    }

    private static final JAnnotationUse setComment(JAnnotationUse $annotation, String comment) {
        return $annotation.param("comments", comment);
    }

    private static final JAnnotationUse appendComment(JAnnotationUse $annotation, String addendum) {
        String currentCommentsValue;
        JAnnotationValue $currentComments = (JAnnotationValue)$annotation.getAnnotationMembers().get("comments");
        String string = currentCommentsValue = $currentComments == null ? "" : CodeModelAnalysis.render((JGenerable)$currentComments);
        if (currentCommentsValue.isBlank()) {
            return $annotation.param("comments", addendum);
        }
        return $annotation.param("comments", JExpr.direct((String)currentCommentsValue).plus(JExpr.lit((String)(" " + addendum))));
    }
}

