/*
 * Decompiled with CFR 0.152.
 */
package de.informaticum.xjc.api;

import com.sun.codemodel.JType;
import com.sun.tools.xjc.BadCommandLineException;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.outline.CustomizableOutline;
import com.sun.tools.xjc.outline.PackageOutline;
import de.informaticum.xjc.util.OutlineAnalysis;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.LoggerFactory;

public interface XjcOption {
    public boolean isActivated();

    public String getArgument();

    default public List<String> getParameters() {
        return Collections.emptyList();
    }

    default public List<String> getParameterValues() {
        return Collections.emptyList();
    }

    public String getDescription();

    public int parseArgument(Options var1, String[] var2, int var3) throws BadCommandLineException;

    default public void doOnActivation(Runnable execution) {
        if (this.isActivated()) {
            execution.run();
        } else {
            LoggerFactory.getLogger(XjcOption.class).trace("Skip execution of XJC option [{}], because it has not been activated.", (Object)this.getArgument());
        }
    }

    default public <R> Optional<R> doOnActivation(Supplier<? extends R> execution) {
        if (this.isActivated()) {
            return Optional.ofNullable(execution.get());
        }
        LoggerFactory.getLogger(XjcOption.class).trace("Skip execution of XJC option [{}], because it has not been activated.", (Object)this.getArgument());
        return Optional.empty();
    }

    private <T> void doOnActivation(Consumer<? super T> execution, T arg, String name) {
        if (this.isActivated()) {
            execution.accept(arg);
        } else {
            LoggerFactory.getLogger(XjcOption.class).trace("Skip execution of XJC option [{}] for [{}], because it has not been activated.", (Object)this.getArgument(), (Object)name);
        }
    }

    default public <CO extends CustomizableOutline> void doOnActivation(Consumer<? super CO> execution, CO clazz) {
        this.doOnActivation(execution, clazz, OutlineAnalysis.fullNameOf(clazz));
    }

    default public <PO extends PackageOutline> void doOnActivation(Consumer<? super PO> execution, PO pakkage) {
        this.doOnActivation(execution, pakkage, OutlineAnalysis.fullNameOf(pakkage));
    }

    default public <JT extends JType> void doOnActivation(Consumer<? super JT> execution, JT $type) {
        this.doOnActivation(execution, $type, $type.fullName());
    }

    private <T, R> Optional<R> doOnActivation(Function<? super T, ? extends R> execution, T arg, String name) {
        if (this.isActivated()) {
            return Optional.ofNullable(execution.apply(arg));
        }
        LoggerFactory.getLogger(XjcOption.class).trace("Skip execution of XJC option [{}] for [{}], because it has not been activated.", (Object)this.getArgument(), (Object)name);
        return Optional.empty();
    }

    default public <CO extends CustomizableOutline, R> Optional<R> doOnActivation(Function<? super CO, ? extends R> execution, CO clazz) {
        return this.doOnActivation(execution, clazz, OutlineAnalysis.fullNameOf(clazz));
    }

    default public <PO extends PackageOutline, R> Optional<R> doOnActivation(Function<? super PO, ? extends R> execution, PO pakkage) {
        return this.doOnActivation(execution, pakkage, OutlineAnalysis.fullNameOf(pakkage));
    }

    default public <JT extends JType, R> Optional<R> doOnActivation(Function<? super JT, ? extends R> execution, JT $type) {
        return this.doOnActivation(execution, $type, $type.fullName());
    }

    private <T, P, R> void doOnActivation(BiConsumer<? super T, ? super P> execution, T arg0, P arg1, String name) {
        if (this.isActivated()) {
            execution.accept(arg0, arg1);
        } else {
            LoggerFactory.getLogger(XjcOption.class).trace("Skip execution of XJC option [{}] for [{}], because it has not been activated.", (Object)this.getArgument(), (Object)name);
        }
    }

    default public <CO extends CustomizableOutline, P> void doOnActivation(BiConsumer<? super CO, ? super P> execution, CO clazz, P param) {
        this.doOnActivation(execution, clazz, param, OutlineAnalysis.fullNameOf(clazz));
    }

    default public <PO extends PackageOutline, P> void doOnActivation(BiConsumer<? super PO, ? super P> execution, PO pakkage, P param) {
        this.doOnActivation(execution, pakkage, param, OutlineAnalysis.fullNameOf(pakkage));
    }

    default public <JT extends JType, P> void doOnActivation(BiConsumer<? super JT, ? super P> execution, JT $type, P param) {
        this.doOnActivation(execution, $type, param, $type.fullName());
    }

    private <T, P, R> Optional<R> doOnActivation(BiFunction<? super T, ? super P, ? extends R> execution, T arg0, P arg1, String name) {
        if (this.isActivated()) {
            return Optional.ofNullable(execution.apply(arg0, arg1));
        }
        LoggerFactory.getLogger(XjcOption.class).trace("Skip execution of XJC option [{}] for [{}], because it has not been activated.", (Object)this.getArgument(), (Object)name);
        return Optional.empty();
    }

    default public <CO extends CustomizableOutline, P, R> Optional<R> doOnActivation(BiFunction<? super CO, ? super P, ? extends R> execution, CO clazz, P param) {
        return this.doOnActivation(execution, clazz, param, OutlineAnalysis.fullNameOf(clazz));
    }

    default public <PO extends PackageOutline, P, R> Optional<R> doOnActivation(BiFunction<? super PO, ? super P, ? extends R> execution, PO pakkage, P param) {
        return this.doOnActivation(execution, pakkage, param, OutlineAnalysis.fullNameOf(pakkage));
    }

    default public <JT extends JType, P, R> Optional<R> doOnActivation(BiFunction<? super JT, ? super P, ? extends R> execution, JT $type, P param) {
        return this.doOnActivation(execution, $type, param, $type.fullName());
    }
}

