/*
 * Decompiled with CFR 0.152.
 */
package de.informaticum.xjc.api;

import com.sun.tools.xjc.BadCommandLineException;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.Plugin;
import de.informaticum.xjc.api.XjcOption;
import de.informaticum.xjc.api.i18n.PluginWithXjcOptionsMessages;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;

public abstract class PluginWithXjcOptions
extends Plugin {
    private final AtomicBoolean cadged = new AtomicBoolean(false);

    public abstract Map.Entry<String, String> getOptionEntry();

    public final String getOptionName() {
        return this.getOptionEntry().getKey();
    }

    public final String getOptionDescription() {
        return this.getOptionEntry().getValue();
    }

    public List<XjcOption> getPluginArguments() {
        return Collections.emptyList();
    }

    public List<XjcOption> getCadgerArguments() {
        return Collections.emptyList();
    }

    public final String getUsage() {
        List<XjcOption> pluginArgs = this.getPluginArguments();
        int width = pluginArgs.stream().mapToInt(arg -> arg.getArgument().length()).max().orElse(this.getOptionName().length());
        StringBuilder usage = new StringBuilder();
        usage.append(String.format("  %1$s :  %2$s%n", "-" + this.getOptionName(), this.getOptionDescription()));
        pluginArgs.forEach(arg -> {
            String argNames = arg.getParameters().stream().map(s -> "<" + s + ">").collect(Collectors.joining(" "));
            usage.append(String.format("  %1$-" + width + "s :  %2$s%n", arg.getArgument() + (String)(argNames.isBlank() ? "" : " " + argNames), arg.getDescription()));
        });
        if (!this.getCadgerArguments().isEmpty()) {
            usage.append(String.format("  %s ", PluginWithXjcOptionsMessages.ADDITIONAL_ARGUMENTS_INTRODUCTION.text()));
            usage.append(this.getCadgerArguments().stream().map(arg -> {
                String argNames = arg.getParameters().stream().map(s -> "<" + s + ">").collect(Collectors.joining(" "));
                return arg.getArgument() + (String)(argNames.isBlank() ? "" : " " + argNames);
            }).collect(Collectors.joining(", ")));
            usage.append(String.format("%n", new Object[0]));
            this.getCadgerArguments();
        }
        return usage.toString();
    }

    public final int parseArgument(Options options, String[] arguments, int index) throws BadCommandLineException {
        if (this.cadged.compareAndSet(false, true)) {
            for (int i = 0; i < arguments.length; ++i) {
                for (XjcOption cadger : this.getCadgerArguments()) {
                    if (!cadger.getArgument().equals(arguments[i])) continue;
                    int consumed = cadger.parseArgument(options, arguments, i);
                    Assertions.assertThat((int)consumed).isPositive();
                    i += consumed - 1;
                }
            }
        }
        if (this.getOptionName().equals(arguments[index])) {
            return 1;
        }
        Optional<XjcOption> possiblyMatchedArgument = this.getPluginArguments().stream().filter(arg -> arg.getArgument().equals(arguments[index])).findFirst();
        return possiblyMatchedArgument.isPresent() ? possiblyMatchedArgument.get().parseArgument(options, arguments, index) : 0;
    }
}

