/*
 * Decompiled with CFR 0.152.
 */
package de.informaticum.xjc.api;

import com.sun.tools.xjc.BadCommandLineException;
import com.sun.tools.xjc.Options;
import de.informaticum.xjc.api.XjcOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.assertj.core.api.Assertions;

public final class CommandLineArgument
implements XjcOption {
    private final String argument;
    private final String description;
    private final LinkedHashMap<String, String> optionParameters;
    private boolean activated;

    public CommandLineArgument(String argument, String description, String ... optionParameters) {
        this(argument, description, Arrays.asList(optionParameters));
    }

    public CommandLineArgument(String argument, String description, List<? extends String> optionParameters) {
        this.argument = Objects.requireNonNull(argument).startsWith("-") ? argument : "-" + argument;
        this.description = Objects.requireNonNull(description);
        this.optionParameters = new LinkedHashMap(optionParameters.size());
        optionParameters.forEach(p -> this.optionParameters.put((String)p, (String)null));
        this.activated = false;
    }

    @Override
    public final String getArgument() {
        return this.argument;
    }

    @Override
    public final List<String> getParameters() {
        return new ArrayList<String>(this.optionParameters.keySet());
    }

    @Override
    public final List<String> getParameterValues() {
        return new ArrayList<String>(this.optionParameters.values());
    }

    @Override
    public final String getDescription() {
        return this.description;
    }

    @Override
    public final boolean isActivated() {
        return this.activated;
    }

    @Override
    public final int parseArgument(Options options, String[] arguments, int index) throws BadCommandLineException {
        Assertions.assertThat((String)this.argument).isEqualTo(arguments[index]);
        this.activated = true;
        for (Map.Entry<String, String> entry : this.optionParameters.entrySet()) {
            entry.setValue(options.requireArgument(this.argument, arguments, ++index));
        }
        return 1 + this.optionParameters.size();
    }

    public final void activates(CommandLineArgument ... affected) {
        this.set(true, affected);
    }

    public final void deactivates(CommandLineArgument ... affected) {
        this.set(false, affected);
    }

    private final void set(boolean state, CommandLineArgument ... affected) {
        if (this.activated) {
            Arrays.asList(affected).forEach(arg -> {
                arg.activated = state;
            });
        }
    }

    public final String toString() {
        return this.argument;
    }
}

