/*
 * Decompiled with CFR 0.152.
 */
package de.informaticum.xjc.api;

import com.sun.codemodel.JDefinedClass;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.model.CElementInfo;
import com.sun.tools.xjc.model.Model;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.ElementOutline;
import com.sun.tools.xjc.outline.EnumOutline;
import com.sun.tools.xjc.outline.Outline;
import com.sun.tools.xjc.outline.PackageOutline;
import de.informaticum.xjc.api.InitialisedErrorHandler;
import de.informaticum.xjc.api.InitialisedOptions;
import de.informaticum.xjc.api.InitialisedOutline;
import de.informaticum.xjc.api.PluginWithXjcOptions;
import de.informaticum.xjc.util.CustomizableOutlineComparator;
import de.informaticum.xjc.util.Lenience;
import de.informaticum.xjc.util.PackageOutlineComparator;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class BasePlugin
extends PluginWithXjcOptions
implements InitialisedOutline,
InitialisedOptions,
InitialisedErrorHandler {
    private static final Logger LOG = LoggerFactory.getLogger(BasePlugin.class);
    private Outline currentOutline = null;
    private Options currentOptions = null;
    private ErrorHandler currentErrorHandler = null;

    @Override
    public final Outline outline() {
        return this.currentOutline != null ? this.currentOutline : InitialisedOutline.super.outline();
    }

    @Override
    public final Options options() {
        return this.currentOptions != null ? this.currentOptions : InitialisedOptions.super.options();
    }

    @Override
    public final ErrorHandler errorHandler() {
        return this.currentErrorHandler != null ? this.currentErrorHandler : InitialisedErrorHandler.super.errorHandler();
    }

    public void postProcessModel(Model model, ErrorHandler errorHandler) {
        super.postProcessModel(model, errorHandler);
    }

    public final boolean run(Outline outline, Options options, ErrorHandler errorHandler) throws SAXException {
        try {
            this.currentOutline = outline;
            this.currentOptions = options;
            this.currentErrorHandler = errorHandler;
            this.sayHi();
            return this.run();
        }
        catch (SAXException any) {
            LOG.error("Plugin cannot recover from error.", (Throwable)any);
            throw any;
        }
        catch (RuntimeException any) {
            LOG.error("Plugin cannot recover from error.", (Throwable)any);
            try {
                errorHandler.fatalError(new SAXParseException(any.getMessage(), null, any));
            }
            catch (RuntimeException ignore) {
                any.addSuppressed(ignore);
            }
            throw any;
        }
        catch (Exception any) {
            LOG.error("Plugin cannot recover from error.", (Throwable)any);
            try {
                errorHandler.fatalError(new SAXParseException(any.getMessage(), null, any));
            }
            catch (RuntimeException ignore) {
                any.addSuppressed(ignore);
            }
            throw new RuntimeException(any.getMessage(), any);
        }
    }

    protected void sayHi() {
        if (LOG.isInfoEnabled()) {
            this.sayHi(arg_0 -> ((Logger)LOG).info(arg_0));
        } else if (LOG.isWarnEnabled()) {
            this.sayHi(arg_0 -> ((Logger)LOG).warn(arg_0));
        } else if (LOG.isErrorEnabled()) {
            this.sayHi(arg_0 -> ((Logger)LOG).error(arg_0));
        }
        this.sayHi(System.out::println);
    }

    protected void sayHi(Consumer<? super String> sink) {
        sink.accept("########################################################################");
        sink.accept("### Hey JAXB/JAX-WS user,");
        sink.accept("### you are using one of the informaticum's XJC plug-ins, i.e., the:");
        sink.accept(String.format("###   - %s (%s),", this.getOptionName(), this.getOptionDescription()));
        sink.accept("### If you appreciate it, let me know at:");
        sink.accept("###   - mailto:xjc@informaticum.de");
        sink.accept("### If you have any improvement or feature suggestion, feel free to");
        sink.accept("### add these at:");
        sink.accept("###   - https://github.com/informaticum/xjc");
        sink.accept("########################################################################");
    }

    protected boolean run() throws SAXException, Exception {
        ElementOutline element;
        boolean result = this.prepareRun();
        for (PackageOutline pakkage : PackageOutlineComparator.sorted(this.currentOutline.getAllPackageContexts())) {
            result &= this.runPackage(pakkage);
            result &= this.runObjectFactory(pakkage.objectFactory());
        }
        for (ClassOutline clazz : CustomizableOutlineComparator.sorted(this.currentOutline.getClasses())) {
            result &= this.runClass(clazz);
        }
        for (EnumOutline enumeration : CustomizableOutlineComparator.sorted(this.currentOutline.getEnums())) {
            result &= this.runEnum(enumeration);
        }
        for (CElementInfo elementInfo : this.currentOutline.getModel().getAllElements()) {
            if (!elementInfo.hasClass()) continue;
            element = this.currentOutline.getElement(elementInfo);
            if (element == null) {
                LOG.error("An element information with a class flag (i.e. {}) should have a corresponding element outline!", (Object)elementInfo.fullName());
                if (Lenience.LENIENT) continue;
                ((ObjectAssert)Assertions.assertThat((Object)element).withFailMessage(Lenience.LENIENT_BREAKPOINT_MESSAGE, new Object[0])).isNotNull();
                continue;
            }
            result &= this.runElement(element);
        }
        for (CElementInfo elementInfo : this.currentOutline.getModel().getAllElements()) {
            if (elementInfo.hasClass()) continue;
            element = this.currentOutline.getElement(elementInfo);
            if (element != null) {
                LOG.error("An element information without a class flag (i.e. {}) should have no corresponding element outline!", (Object)elementInfo.fullName());
                if (!Lenience.LENIENT) {
                    ((ObjectAssert)Assertions.assertThat((Object)element).withFailMessage(Lenience.LENIENT_BREAKPOINT_MESSAGE, new Object[0])).isNull();
                }
            }
            result &= this.runElementInfo(elementInfo);
        }
        return result;
    }

    protected boolean prepareRun() throws SAXException, Exception {
        return true;
    }

    protected boolean runPackage(PackageOutline pakkage) throws SAXException, Exception {
        return true;
    }

    protected boolean runObjectFactory(JDefinedClass $Factory) throws SAXException, Exception {
        return true;
    }

    protected boolean runClass(ClassOutline clazz) throws SAXException, Exception {
        return true;
    }

    protected boolean runEnum(EnumOutline enumeration) throws SAXException, Exception {
        return true;
    }

    protected boolean runElement(ElementOutline element) throws SAXException, Exception {
        return true;
    }

    protected boolean runElementInfo(CElementInfo elementInfo) throws SAXException, Exception {
        return true;
    }
}

