package de.informaticum.xjc.plugins.i18n;

import static java.util.ResourceBundle.getBundle;
import java.util.ResourceBundle;
import de.informaticum.xjc.api.ResourceBundleEntry;

/**
 * Enumeration of all i18n messages keys used by the {@link de.informaticum.xjc.plugins.ConstructionPlugin}.
 */
public enum ConstructionPluginMessages
implements ResourceBundleEntry {

    /* A. Description of the XJC Plugin */
    OPTION_DESCRIPTION,

    /* B. Description of the XJC Plugin's Options */
    DEFAULT_CONSTRUCTOR_DESCRIPTION,
    VALUES_CONSTRUCTOR_DESCRIPTION,
    BASIC_CONSTRUCTOR_DESCRIPTION,
    COPY_CONSTRUCTOR_DESCRIPTION,
    PROTECTED_DEFAULT_CONSTRUCTOR_DESCRIPTION,
    CLONE_DESCRIPTION,
    BUILDER_DESCRIPTION,
    FACTORY_WITHER_DESCRIPTION,
    ADDITIONAL_WITHER_DESCRIPTION,
    HIDDEN_FACTORIES_DESCRIPTION,
    REMOVE_FACTORIES_DESCRIPTION,

    /* C. Main Javadoc Contents and Javadoc Supply (@param, @throws, etc.) */
    CONSTRUCTOR_JAVADOC_BEGIN,
    CONSTRUCTOR_JAVADOC_SUPER_CLASS,
    CONSTRUCTOR_JAVADOC_END,
    CONSTRUCTOR_COMMENT,
    CONSTRUCTOR_BLUEPRINT_ARGUMENT,
    CONSTRUCTOR_ILLEGAL_BLUEPRINT,
    PROTECTED_CONSTRUCTOR_IMPLNOTE,
    PROTECTED_CONSTRUCTOR_COMMENT,
    ALTERNATIVE_CONSTRUCTORS,
    ALTERNATIVE_BUILDER,
    ALTERNATIVE_INSTANTIATION,
    IMPLEMENTS_IMPLNOTE,
    CLONE_IMPLNOTE,
    CLONE_COMMENT,
    BUILDER_JAVADOC,
    BUILDER_IMPLNOTE,
    BUILDER_COMMENT,
    BUILDER_ABSTRACT_IMPLNOTE,
    BUILDER_DEFAULT_CONSTRUCTOR,
    BUILDER_DEFAULT_CONSTRUCTOR_COMMENT,
    BUILDER_BLUEPRINT_CONSTRUCTOR,
    BUILDER_BLUEPRINT_CONSTRUCTOR_COMMENT,
    BUILDER_BLUEPRINT_ARGUMENT,
    BUILDER_ILLEGAL_BLUEPRINT,
    BUILDER_WITHER_JAVADOC,
    BUILDER_WITHER_COMMENT,
    BUILDER_WITHER_RETURN,
    BUILDER_ADDER_JAVADOC,
    BUILDER_ADDER_COMMENT,
    BUILDER_ADDER_ARGUMENT,
    BUILDER_ADDER_RETURN,
    BUILDER_REMOVER_JAVADOC,
    BUILDER_REMOVER_COMMENT,
    BUILDER_REMOVER_ARGUMENT,
    BUILDER_REMOVER_RETURN,
    BUILDER_BUILD_JAVADOC,
    BUILDER_BUILD_IMPLNOTE,
    BUILDER_BUILD_COMMENT,
    BUILDER_BUILD_ABSTRACT_IMPLNOTE,
    BUILDER_BUILD_RETURN,
    BUILDER_BUILD_RELAY_THROWS,
    BUILDER_METHOD_JAVADOC,
    BUILDER_METHOD_IMPLNOTE,
    BUILDER_METHOD_COMMENT,
    BUILDER_METHOD_RETURN,
    TOBUILDER_METHOD_JAVADOC,
    TOBUILDER_METHOD_IMPLNOTE,
    TOBUILDER_METHOD_COMMENT,
    TOBUILDER_METHOD_ABSTRACT_IMPLNOTE,
    TOBUILDER_METHOD_RETURN,
    TOBUILDER_ILLEGAL_INSTANCE,
    WITHER_JAVADOC,
    WITHER_ARGUMENT,
    WITHER_RETURN,
    WITHER_IMPLNOTE,
    WITHER_COMMENT,
    WITHER_ABSTRACT_IMPLNOTE,
    ADDER_JAVADOC,
    ADDER_ARGUMENT,
    ADDER_RETURN,
    ADDER_IMPLNOTE,
    ADDER_COMMENT,
    ADDER_ABSTRACT_IMPLNOTE,
    REMOVER_JAVADOC,
    REMOVER_ARGUMENT,
    REMOVER_RETURN,
    REMOVER_IMPLNOTE,
    REMOVER_COMMENT,
    REMOVER_ABSTRACT_IMPLNOTE,
    PRIVATE_FACTORY_IMPLNOTE,

    ;

    private static final ResourceBundle RB = getBundle(ConstructionPluginMessages.class.getName().replace(".i18n.", ".l10n."));

    @Override
    public final ResourceBundle bundle() {
        return RB;
    }

}
