/*
 * Decompiled with CFR 0.152.
 */
package com.inet.sass.visitor;

import com.inet.sass.ScssContext;
import com.inet.sass.expression.BinaryOperator;
import com.inet.sass.handler.SCSSErrorHandler;
import com.inet.sass.parser.ParseException;
import com.inet.sass.parser.SassListItem;
import com.inet.sass.tree.Node;
import com.inet.sass.tree.controldirective.TemporaryNode;
import com.inet.sass.tree.controldirective.WhileNode;
import com.inet.sass.visitor.LoopNodeHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class WhileNodeHandler {
    public static Collection<Node> traverse(ScssContext context, WhileNode whileNode) {
        TemporaryNode tempParent = new TemporaryNode(whileNode.getParentNode());
        List<Node> children = whileNode.getChildren();
        while (WhileNodeHandler.evaluateCondition(context, whileNode)) {
            if (children.size() == 0) {
                SCSSErrorHandler.get().error(new ParseException("@while loop iteration did nothing, infinite loop", whileNode));
                return children;
            }
            LoopNodeHandler.iteration(context, children, tempParent, Collections.emptyList());
        }
        return tempParent.getChildren();
    }

    private static boolean evaluateCondition(ScssContext context, WhileNode whileNode) {
        SassListItem condition = whileNode.getCondition();
        condition = condition.evaluateFunctionsAndExpressions(context, true);
        return BinaryOperator.isTrue(condition);
    }
}

