/*
 * Decompiled with CFR 0.152.
 */
package com.inet.sass.visitor;

import com.inet.sass.Scope;
import com.inet.sass.ScssContext;
import com.inet.sass.handler.SCSSErrorHandler;
import com.inet.sass.parser.ParseException;
import com.inet.sass.parser.Variable;
import com.inet.sass.tree.MixinDefNode;
import com.inet.sass.tree.MixinNode;
import com.inet.sass.tree.Node;
import com.inet.sass.tree.controldirective.TemporaryNode;
import java.util.Collection;
import java.util.Collections;

public class MixinNodeHandler {
    public static Collection<Node> traverse(ScssContext context, MixinNode node) {
        return MixinNodeHandler.replaceMixins(context, node);
    }

    private static Collection<Node> replaceMixins(ScssContext context, MixinNode node) {
        MixinDefNode mixinDef = context.getMixinDefinition(node.getName());
        if (mixinDef == null) {
            SCSSErrorHandler.get().error(new ParseException("Mixin Definition: " + node.getName() + " not found", node));
            return Collections.emptyList();
        }
        return MixinNodeHandler.replaceMixinNode(context, node, mixinDef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<Node> replaceMixinNode(ScssContext context, MixinNode mixinNode, MixinDefNode mixinDef) {
        MixinDefNode defClone = mixinDef.copy();
        defClone.replaceContentDirective(context, mixinNode);
        if (!mixinDef.getArglist().isEmpty()) {
            defClone.replacePossibleArguments(mixinNode.getArglist());
        }
        Scope previousScope = context.openVariableScope(defClone.getDefinitionScope());
        try {
            for (Variable var : defClone.getArglist().getArguments()) {
                Variable evaluated = new Variable(var.getName(), var.getExpr().evaluateFunctionsAndExpressions(context, true));
                context.addVariable(evaluated);
            }
            TemporaryNode tempParent = new TemporaryNode(mixinNode.getParentNode(), defClone.getChildren());
            Collection<Node> collection = ((Node)tempParent).traverse(context);
            return collection;
        }
        finally {
            context.closeVariableScope(previousScope);
        }
    }
}

