/*
 * Decompiled with CFR 0.152.
 */
package com.inet.sass.visitor;

import com.inet.sass.ScssContext;
import com.inet.sass.ScssStylesheet;
import com.inet.sass.handler.SCSSErrorHandler;
import com.inet.sass.tree.ImportNode;
import com.inet.sass.tree.Node;
import com.inet.sass.tree.NodeWithUrlContent;
import com.inet.sass.tree.RuleNode;
import com.inet.sass.tree.controldirective.TemporaryNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ImportNodeHandler {
    public static Collection<Node> traverse(ScssContext context, ImportNode importNode) {
        ScssStylesheet styleSheet = context.getStylesheet();
        if (!importNode.isPureCssImport()) {
            List<Node> importedChildren = Collections.emptyList();
            ScssStylesheet imported = null;
            try {
                imported = styleSheet.importStylesheet(importNode.getUri());
                if (imported == null) {
                    SCSSErrorHandler.get().error("Import '" + importNode.getUri() + "' in '" + styleSheet.getUri() + "' could not be found");
                    return Collections.emptyList();
                }
                String prefix = styleSheet.getPrefix() + ImportNodeHandler.getUrlPrefix(importNode.getUri());
                if (!"".equals(prefix)) {
                    imported.setPrefix(prefix);
                    ImportNodeHandler.updateUrlInImportedSheet(imported, prefix, imported, context);
                }
                importedChildren = new ArrayList<Node>(imported.getChildren());
            }
            catch (Exception e) {
                SCSSErrorHandler.get().error(e);
                return Collections.emptyList();
            }
            context.setStylesheet(imported);
            TemporaryNode tempParent = new TemporaryNode(importNode.getParentNode(), importedChildren);
            Collection<Node> result = ((Node)tempParent).traverseChildren(context);
            styleSheet.addSourceUris(imported.getSourceUris());
            context.setStylesheet(styleSheet);
            return result;
        }
        if (styleSheet != importNode.getParentNode()) {
            SCSSErrorHandler.get().error("CSS imports can only be used at the top level, not as nested imports. Within style rules, use SCSS imports.");
            return Collections.emptyList();
        }
        return Collections.singleton(importNode);
    }

    private static String getUrlPrefix(String url) {
        if (url == null) {
            return "";
        }
        int pos = url.lastIndexOf(47);
        if (pos == -1) {
            return "";
        }
        return url.substring(0, pos + 1);
    }

    private static void updateUrlInImportedSheet(Node node, String prefix, ScssStylesheet styleSheet, ScssContext context) {
        ScssContext.UrlMode urlMode = context.getUrlMode();
        if (urlMode == ScssContext.UrlMode.ABSOLUTE) {
            return;
        }
        List<Node> children = node.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            Node child;
            Node newChild = child = children.get(i);
            if (child instanceof NodeWithUrlContent && (urlMode == ScssContext.UrlMode.RELATIVE || urlMode == ScssContext.UrlMode.MIXED && child instanceof RuleNode) && child != (newChild = (Node)((Object)((NodeWithUrlContent)((Object)child)).updateUrl(prefix)))) {
                node.replaceNodeAt(i, newChild);
            }
            ImportNodeHandler.updateUrlInImportedSheet(newChild, prefix, styleSheet, context);
        }
    }
}

