/*
 * Decompiled with CFR 0.152.
 */
package com.inet.sass.visitor;

import com.inet.sass.ScssContext;
import com.inet.sass.expression.BinaryOperator;
import com.inet.sass.parser.ParseException;
import com.inet.sass.parser.SassListItem;
import com.inet.sass.tree.Node;
import com.inet.sass.tree.controldirective.ElseNode;
import com.inet.sass.tree.controldirective.IfElseDefNode;
import com.inet.sass.tree.controldirective.IfNode;
import com.inet.sass.tree.controldirective.TemporaryNode;
import java.util.Collection;
import java.util.Collections;

public class IfElseNodeHandler {
    public static Collection<Node> traverse(ScssContext context, IfElseDefNode node) throws Exception {
        for (Node child : node.getChildren()) {
            if (child instanceof IfNode) {
                SassListItem expression = ((IfNode)child).getExpression();
                if (!BinaryOperator.isTrue(expression = expression.evaluateFunctionsAndExpressions(context, true))) continue;
                return IfElseNodeHandler.traverseChild(context, node.getParentNode(), child);
            }
            if (!(child instanceof ElseNode) && node.getChildren().indexOf(child) == node.getChildren().size() - 1) {
                throw new ParseException("Invalid @if/@else in scss file for " + node, node);
            }
            return IfElseNodeHandler.traverseChild(context, node.getParentNode(), child);
        }
        return Collections.emptyList();
    }

    private static Collection<Node> traverseChild(ScssContext context, Node parent, Node child) {
        TemporaryNode tempParent = new TemporaryNode(parent, child.getChildren());
        return tempParent.traverse(context);
    }
}

