/*
 * Decompiled with CFR 0.152.
 */
package com.inet.sass.visitor;

import com.inet.sass.ScssContext;
import com.inet.sass.parser.LexicalUnitImpl;
import com.inet.sass.parser.ParseException;
import com.inet.sass.parser.SassListItem;
import com.inet.sass.parser.Variable;
import com.inet.sass.tree.Node;
import com.inet.sass.tree.controldirective.ForNode;
import com.inet.sass.visitor.LoopNodeHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ForNodeHandler
extends LoopNodeHandler {
    public static Collection<Node> traverse(ScssContext context, ForNode forNode) {
        int fromInt = ForNodeHandler.getInt(context, forNode.getFrom());
        int toInt = ForNodeHandler.getInt(context, forNode.getTo());
        if (forNode.isExclusive()) {
            --toInt;
        }
        ArrayList<List<Variable>> indices = new ArrayList<List<Variable>>();
        for (int idx = fromInt; idx <= toInt; ++idx) {
            SassListItem from = forNode.getFrom();
            LexicalUnitImpl idxUnit = LexicalUnitImpl.createInteger(from.getUri(), from.getLineNumber(), from.getColumnNumber(), idx);
            indices.add(Collections.singletonList(new Variable(forNode.getVariableName(), idxUnit)));
        }
        return ForNodeHandler.replaceLoopNode(context, forNode, indices);
    }

    private static int getInt(ScssContext context, SassListItem item) {
        SassListItem value = item.evaluateFunctionsAndExpressions(context, true);
        if (value instanceof LexicalUnitImpl && ((LexicalUnitImpl)value).isNumber()) {
            return ((LexicalUnitImpl)value).getIntegerValue();
        }
        throw new ParseException("The loop indices of @for must evaluate to integer values", item);
    }
}

