/*
 * Decompiled with CFR 0.152.
 */
package com.inet.sass.visitor;

import com.inet.sass.ScssContext;
import com.inet.sass.parser.ParseException;
import com.inet.sass.selector.Selector;
import com.inet.sass.selector.SelectorSet;
import com.inet.sass.selector.SimpleSelectorSequence;
import com.inet.sass.tree.BlockNode;
import com.inet.sass.tree.ExtendNode;
import com.inet.sass.tree.MediaNode;
import com.inet.sass.tree.Node;
import com.inet.sass.visitor.Extension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ExtendNodeHandler {
    public static Collection<Node> traverse(ScssContext context, ExtendNode node) throws Exception {
        for (Selector s : node.getList()) {
            if (!s.isSimple()) {
                throw new ParseException("Nested selector not allowed in @extend-clause");
            }
            Node parentNode = node.getNormalParentNode();
            if (!(parentNode instanceof BlockNode)) continue;
            BlockNode parentBlock = (BlockNode)parentNode;
            SimpleSelectorSequence extendSelector = s.firstSimple();
            for (Selector sel : parentBlock.getSelectorList()) {
                List<Selector> ctx = parentBlock.getParentSelectors();
                context.addExtension(new Extension(extendSelector, sel, ctx));
            }
        }
        return Collections.emptyList();
    }

    public static void modifyTree(ScssContext context, Node node) {
        Iterable<Extension> extensions = context.getExtensions();
        Iterator<Node> nodeIt = node.getChildren().iterator();
        while (nodeIt.hasNext()) {
            Node child = nodeIt.next();
            Class<?> clazz = child.getClass();
            if (clazz == BlockNode.class) {
                BlockNode blockNode = (BlockNode)child;
                SelectorSet newSelectors = new SelectorSet();
                for (Selector selector : blockNode.getSelectorList()) {
                    newSelectors.add(selector);
                    newSelectors.addAll(ExtendNodeHandler.createSelectorsForExtensions(selector, extensions));
                }
                Iterator it = newSelectors.iterator();
                while (it.hasNext()) {
                    Selector s = (Selector)it.next();
                    if (!s.isPlaceholder()) continue;
                    it.remove();
                }
                if (newSelectors.isEmpty()) {
                    nodeIt.remove();
                    continue;
                }
                blockNode.setSelectorList(new ArrayList<Selector>(newSelectors));
                continue;
            }
            if (clazz != MediaNode.class) continue;
            ExtendNodeHandler.modifyTree(context, child);
        }
    }

    public static SelectorSet createSelectorsForExtensions(Selector target, Iterable<Extension> extendsMap) {
        SelectorSet newSelectors = new SelectorSet();
        ExtendNodeHandler.createSelectorsForExtensionsRecursively(target, newSelectors, extendsMap);
        return newSelectors.eliminateRedundantSelectors();
    }

    private static void createSelectorsForExtensionsRecursively(Selector target, SelectorSet current, Iterable<Extension> extendsMap) {
        SelectorSet newSelectors = new SelectorSet();
        for (Extension extension : extendsMap) {
            Selector replaced = target.replace(extension);
            boolean newSelector = current.add(replaced);
            if (!newSelector || replaced.equals(target)) continue;
            newSelectors.add(replaced);
        }
        for (Selector newSelector : newSelectors) {
            ExtendNodeHandler.createSelectorsForExtensionsRecursively(newSelector, current, extendsMap);
        }
    }
}

