/*
 * Decompiled with CFR 0.152.
 */
package com.inet.sass.visitor;

import com.inet.sass.ScssContext;
import com.inet.sass.ScssStylesheet;
import com.inet.sass.selector.Selector;
import com.inet.sass.tree.BlockNode;
import com.inet.sass.tree.MediaNode;
import com.inet.sass.tree.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class BlockNodeHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Node> traverse(ScssContext context, BlockNode node) {
        if (node.getChildren().size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<Node> result = new ArrayList<Node>();
        BlockNodeHandler.updateSelectors(node);
        List<Node> children = node.getChildren();
        if (!children.isEmpty()) {
            context.openVariableScope();
            BlockNode oldParent = context.getParentBlock();
            context.setParentBlock(node);
            try {
                ArrayList<Node> newChildren = null;
                for (Node child : children) {
                    if (child.getClass() == BlockNode.class) {
                        ((BlockNode)child).setParentSelectors(node.getSelectorList());
                        result.addAll(child.traverse(context));
                        continue;
                    }
                    if (child.getClass() == MediaNode.class) {
                        BlockNodeHandler.bubbleMedia(result, context, node, (MediaNode)child, true);
                        continue;
                    }
                    Collection<Node> childTraversed = child.traverse(context);
                    for (Node n : childTraversed) {
                        if (n.getClass() == BlockNode.class) {
                            result.add(n);
                            continue;
                        }
                        if (n.getClass() == MediaNode.class) {
                            BlockNodeHandler.bubbleMedia(result, context, node, (MediaNode)n, false);
                            continue;
                        }
                        if (newChildren == null) {
                            newChildren = new ArrayList<Node>();
                        }
                        newChildren.add(n);
                    }
                }
                if (newChildren != null) {
                    BlockNode newNode = new BlockNode(node, newChildren);
                    newNode.setParentSelectors(node.getParentSelectors());
                    result.add(0, newNode);
                }
            }
            finally {
                context.closeVariableScope();
                context.setParentBlock(oldParent);
            }
        }
        return result;
    }

    static void bubbleMedia(ArrayList<Node> result, ScssContext context, BlockNode node, MediaNode child, boolean traverse) {
        block3: {
            for (Selector selector : node.getSelectorList()) {
                if (!selector.isPlaceholder()) continue;
                return;
            }
            if (!traverse) {
                List<Node> children = child.getChildren();
                for (Node c : children) {
                    if (c.getClass() == BlockNode.class) continue;
                    break block3;
                }
                result.add(child);
                return;
            }
        }
        MediaNode media = new MediaNode(child.getUri(), child.getLineNumber(), child.getColumnNumber(), child.getMedia());
        media.appendChild(new BlockNode(node, child.getChildren()));
        result.addAll(media.traverse(context));
    }

    private static void updateSelectors(BlockNode node) {
        Node parentBlock = node.getNormalParentNode();
        if (parentBlock instanceof BlockNode) {
            BlockNodeHandler.replaceParentSelectors((BlockNode)parentBlock, node);
        } else if (node.getSelectors().contains("&")) {
            ScssStylesheet.warning("Base-level rule contains the parent-selector-referencing character '&'; the character will be removed:\n" + node);
            BlockNodeHandler.removeParentReference(node);
        }
    }

    private static void removeParentReference(BlockNode node) {
        ArrayList<Selector> newSelectors = new ArrayList<Selector>();
        for (Selector sel : node.getSelectorList()) {
            newSelectors.add(sel.replaceParentReference(null));
        }
        node.setSelectorList(newSelectors);
    }

    private static void replaceParentSelectors(BlockNode parentBlock, BlockNode node) {
        ArrayList<Selector> newSelectors = new ArrayList<Selector>();
        for (Selector parentSel : parentBlock.getSelectorList()) {
            for (Selector sel : node.getSelectorList()) {
                newSelectors.add(sel.replaceParentReference(parentSel));
            }
        }
        node.setSelectorList(newSelectors);
    }
}

