/*
 * Decompiled with CFR 0.152.
 */
package com.inet.sass.tree.controldirective;

import com.inet.sass.ScssContext;
import com.inet.sass.parser.SassListItem;
import com.inet.sass.tree.Node;
import com.inet.sass.tree.NodeWithUrlContent;
import com.inet.sass.visitor.EachNodeHandler;
import java.util.Collection;
import java.util.List;

public class EachDefNode
extends Node
implements NodeWithUrlContent {
    private List<String> variableNames;
    private SassListItem list;

    public EachDefNode(List<String> variableNames, SassListItem list) {
        this.variableNames = variableNames;
        this.list = list;
    }

    private EachDefNode(EachDefNode nodeToCopy) {
        super(nodeToCopy);
        this.variableNames = nodeToCopy.variableNames;
        this.list = nodeToCopy.list;
    }

    public SassListItem getVariables() {
        return this.list;
    }

    public List<String> getVariableNames() {
        return this.variableNames;
    }

    public String toString() {
        return "Each Definition Node: {variable : " + this.variableNames + ", children : " + this.list + "}";
    }

    @Override
    public Collection<Node> traverse(ScssContext context) {
        return EachNodeHandler.traverse(context, this);
    }

    @Override
    public EachDefNode copy() {
        return new EachDefNode(this);
    }

    @Override
    public NodeWithUrlContent updateUrl(String prefix) {
        SassListItem list = this.list;
        SassListItem newList = list.updateUrl(prefix);
        if (list != newList) {
            EachDefNode copy = this.copy();
            copy.list = newList;
            return copy;
        }
        return this;
    }
}

