/*
 * Decompiled with CFR 0.152.
 */
package com.inet.sass.tree;

import com.inet.sass.Definition;
import com.inet.sass.ScssContext;
import com.inet.sass.parser.SassListItem;
import com.inet.sass.parser.Variable;
import com.inet.sass.tree.Node;
import com.inet.sass.tree.NodeWithUrlContent;
import com.inet.sass.visitor.VariableNodeHandler;
import java.util.Collection;
import java.util.Collections;

public class VariableNode
extends Node
implements Definition,
NodeWithUrlContent {
    private final Variable variable;

    public VariableNode(String name, SassListItem expr, boolean guarded) {
        this.variable = new Variable(name, expr, guarded);
    }

    public SassListItem getExpr() {
        return this.variable.getExpr();
    }

    public void setExpr(SassListItem expr) {
        this.variable.setExpr(expr);
    }

    @Override
    public String getName() {
        return this.variable.getName();
    }

    public boolean isGuarded() {
        return this.variable.isGuarded();
    }

    public Variable getVariable() {
        return this.variable;
    }

    @Override
    public String printState() {
        return this.buildString(PRINT_STRATEGY);
    }

    public String toString() {
        return "Variable node [" + this.buildString(TO_STRING_STRATEGY) + "]";
    }

    @Override
    public Collection<Node> traverse(ScssContext context) {
        boolean hasOperator = this.variable.getExpr().containsArithmeticalOperator();
        this.variable.setExpr(this.variable.getExpr().evaluateFunctionsAndExpressions(context, hasOperator));
        VariableNodeHandler.traverse(context, this);
        return Collections.emptyList();
    }

    private String buildString(Node.BuildStringStrategy strategy) {
        StringBuilder builder = new StringBuilder("$");
        builder.append(this.getName()).append(": ").append(strategy.build(this.getExpr()));
        return builder.toString();
    }

    @Override
    public VariableNode copy() {
        return new VariableNode(this.getName(), this.getExpr(), this.isGuarded());
    }

    @Override
    public VariableNode updateUrl(String prefix) {
        if (this.getExpr() != null) {
            SassListItem newExpr = this.variable.getExpr().updateUrl(prefix);
            return new VariableNode(this.getName(), newExpr, this.isGuarded());
        }
        return this;
    }
}

