/*
 * Decompiled with CFR 0.152.
 */
package com.inet.sass.tree;

import com.inet.sass.ScssContext;
import com.inet.sass.parser.SassListItem;
import com.inet.sass.parser.StringInterpolationSequence;
import com.inet.sass.tree.Node;
import com.inet.sass.tree.NodeWithUrlContent;
import java.util.Collection;
import java.util.Collections;

public class RuleNode
extends Node
implements NodeWithUrlContent {
    StringInterpolationSequence variable;
    SassListItem value;
    String comment;
    private boolean important;

    public RuleNode(StringInterpolationSequence variable, SassListItem value, boolean important, String comment) {
        this.variable = variable;
        this.value = value;
        this.important = important;
        this.comment = comment;
    }

    private RuleNode(RuleNode nodeToCopy) {
        super(nodeToCopy);
        this.variable = nodeToCopy.variable;
        this.value = nodeToCopy.value;
        this.comment = nodeToCopy.comment;
        this.important = nodeToCopy.important;
    }

    public StringInterpolationSequence getVariable() {
        return this.variable;
    }

    public void setVariable(StringInterpolationSequence variable) {
        this.variable = variable;
    }

    public SassListItem getValue() {
        return this.value;
    }

    @Override
    public String printState() {
        return this.buildString(PRINT_STRATEGY);
    }

    public String toString() {
        return "Rule node [" + this.buildString(TO_STRING_STRATEGY) + "]";
    }

    public boolean isImportant() {
        return this.important;
    }

    public void setImportant(boolean important) {
        this.important = important;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    public Collection<Node> traverse(ScssContext context) {
        boolean hasOperators = this.value.containsArithmeticalOperator();
        this.variable = this.variable.replaceVariables(context);
        this.value = this.value.evaluateFunctionsAndExpressions(context, hasOperators);
        return Collections.singleton(this);
    }

    private String buildString(Node.BuildStringStrategy strategy) {
        String stringValue = strategy.build(this.value) + (this.important ? " !important" : "");
        StringBuilder builder = new StringBuilder();
        if (!"".equals(stringValue.trim())) {
            builder.append(this.variable);
            builder.append(": ");
            builder.append(stringValue);
            builder.append(';');
        }
        if (this.comment != null) {
            builder.append(this.comment);
        }
        return builder.toString();
    }

    @Override
    public RuleNode copy() {
        return new RuleNode(this);
    }

    @Override
    public RuleNode updateUrl(String prefix) {
        SassListItem newValue;
        SassListItem value = this.value;
        if (value != null && (newValue = value.updateUrl(prefix)) != value) {
            RuleNode newInstance = this.copy();
            newInstance.value = newValue;
            return newInstance;
        }
        return this;
    }
}

