/*
 * Decompiled with CFR 0.152.
 */
package com.inet.sass.tree;

import com.inet.sass.ScssContext;
import com.inet.sass.parser.ActualArgumentList;
import com.inet.sass.parser.ParseException;
import com.inet.sass.parser.SassListItem;
import com.inet.sass.tree.SourceLocation;
import com.inet.sass.tree.controldirective.TemporaryNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public abstract class Node
implements SourceLocation {
    public static BuildStringStrategy PRINT_STRATEGY = new PrintStrategy();
    public static BuildStringStrategy TO_STRING_STRATEGY = new ToStringStrategy();
    private ArrayList<Node> children;
    private Node parentNode;
    private int line;
    private int column;
    private String uri;

    protected Node() {
    }

    protected Node(String uri, int line, int column) {
        this.uri = uri;
        this.line = line;
        this.column = column;
    }

    protected Node(Node nodeToCopy) {
        if (nodeToCopy != null) {
            if (nodeToCopy.children != null) {
                this.setChildren(nodeToCopy.copyChildren());
            }
            this.uri = nodeToCopy.uri;
            this.line = nodeToCopy.line;
            this.column = nodeToCopy.column;
        }
    }

    public void replaceNodeAt(int index, Node newChild) {
        newChild.removeFromParent();
        newChild.parentNode = this;
        this.children.set(index, newChild);
    }

    public void replaceNode(Node oldChild, Collection<? extends Node> newNodes) {
        this.appendAfterNode(oldChild, newNodes);
        if (!newNodes.contains(oldChild)) {
            oldChild.removeFromParent();
        }
    }

    private void appendAfterNode(Node after, Collection<? extends Node> newNodes) {
        if (newNodes != null && !newNodes.isEmpty()) {
            ArrayList<Node> children = this.children;
            if (children != null) {
                for (int i = children.size() - 1; i >= 0; --i) {
                    Node node = children.get(i);
                    if (node != after) continue;
                    children.addAll(i + 1, newNodes);
                    for (Node node2 : newNodes) {
                        node2.removeFromParent();
                        node2.parentNode = this;
                    }
                    return;
                }
            }
            throw new ParseException("after-node was not found", after);
        }
    }

    public void appendChild(Node node) {
        if (node != null) {
            this.getChildren(true).add(node);
            node.removeFromParent();
            node.parentNode = this;
        }
    }

    private void removeFromParent() {
        if (this.getParentNode() != null) {
            this.getParentNode().getChildren(true).remove(this);
            this.parentNode = null;
        }
    }

    public List<Node> getChildren() {
        return this.getChildren(false);
    }

    @Deprecated
    protected void setChildren(Collection<Node> newChildren) {
        this.children = new ArrayList<Node>(newChildren);
        for (Node child : newChildren) {
            child.parentNode = this;
        }
    }

    private List<Node> getChildren(boolean create) {
        if (this.children == null && create) {
            this.children = new ArrayList();
        }
        if (this.children != null) {
            return this.children;
        }
        return Collections.emptyList();
    }

    public abstract Collection<Node> traverse(ScssContext var1);

    public String printState() {
        return null;
    }

    public Node getParentNode() {
        return this.parentNode;
    }

    public Node getNormalParentNode() {
        Node parent = this.getParentNode();
        while (parent instanceof TemporaryNode) {
            parent = parent.getParentNode();
        }
        return parent;
    }

    public abstract Node copy();

    protected Collection<Node> copyChildren() {
        ArrayList<Node> children = this.children;
        if (children == null || children.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Node> result = new ArrayList<Node>();
        for (Node child : children) {
            result.add(child.copy());
        }
        return result;
    }

    public Collection<Node> traverseChildren(ScssContext context) {
        return this.traverseChildren(context, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<Node> traverseChildren(ScssContext context, boolean newScope) {
        List<Node> children = this.getChildren();
        if (!children.isEmpty()) {
            if (newScope) {
                context.openVariableScope();
            }
            try {
                ArrayList<Node> result = new ArrayList<Node>();
                for (Node child : children) {
                    result.addAll(child.traverse(context));
                }
                this.setChildren(result);
                ArrayList<Node> arrayList = result;
                return arrayList;
            }
            finally {
                if (newScope) {
                    context.closeVariableScope();
                }
            }
        }
        return Collections.emptyList();
    }

    @Override
    public int getLineNumber() {
        return this.line;
    }

    @Override
    public int getColumnNumber() {
        return this.column;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    public static class PrintStrategy
    implements BuildStringStrategy {
        @Override
        public String build(Node node) {
            return node.printState();
        }

        @Override
        public String build(SassListItem expr) {
            return expr.printState();
        }

        @Override
        public String build(ActualArgumentList expr) {
            return expr.printState();
        }
    }

    public static interface BuildStringStrategy {
        public String build(Node var1);

        public String build(SassListItem var1);

        public String build(ActualArgumentList var1);
    }

    public static class ToStringStrategy
    implements BuildStringStrategy {
        @Override
        public String build(Node node) {
            return node.toString();
        }

        @Override
        public String build(SassListItem expr) {
            return expr.toString();
        }

        @Override
        public String build(ActualArgumentList expr) {
            return expr.toString();
        }
    }
}

