/*
 * Decompiled with CFR 0.152.
 */
package com.inet.sass.tree;

import com.inet.sass.ScssContext;
import com.inet.sass.parser.StringInterpolationSequence;
import com.inet.sass.tree.Node;
import com.inet.sass.tree.RuleNode;
import java.util.ArrayList;
import java.util.Collection;

public class NestPropertiesNode
extends Node {
    private StringInterpolationSequence name;

    public NestPropertiesNode(StringInterpolationSequence name) {
        this.name = name;
    }

    private NestPropertiesNode(NestPropertiesNode nodeToCopy) {
        super(nodeToCopy);
        this.name = nodeToCopy.name;
    }

    public StringInterpolationSequence getName() {
        return this.name;
    }

    public void setName(StringInterpolationSequence name) {
        this.name = name;
    }

    public String toString() {
        return "Nest properties node [ name = " + this.name + " ]";
    }

    public Collection<Node> unNesting() {
        ArrayList<Node> result = new ArrayList<Node>();
        for (Node child : this.getChildren()) {
            RuleNode createNewRuleNodeFromChild = this.createNewRuleNodeFromChild((RuleNode)child);
            result.add(createNewRuleNodeFromChild);
        }
        return result;
    }

    public RuleNode createNewRuleNodeFromChild(RuleNode child) {
        StringInterpolationSequence newName = this.name.append(new StringInterpolationSequence("-"));
        newName = newName.append(child.getVariable());
        RuleNode newRuleNode = new RuleNode(newName, child.getValue(), child.isImportant(), null);
        return newRuleNode;
    }

    @Override
    public Collection<Node> traverse(ScssContext context) {
        this.traverseChildren(context);
        this.name = this.name.replaceVariables(context);
        return this.unNesting();
    }

    @Override
    public String printState() {
        return null;
    }

    @Override
    public NestPropertiesNode copy() {
        return new NestPropertiesNode(this);
    }
}

