/*
 * Decompiled with CFR 0.152.
 */
package com.inet.sass.tree;

import com.inet.sass.ScssContext;
import com.inet.sass.handler.SCSSErrorHandler;
import com.inet.sass.parser.ActualArgumentList;
import com.inet.sass.tree.Node;
import com.inet.sass.tree.NodeWithUrlContent;
import com.inet.sass.visitor.MixinNodeHandler;
import java.util.Collection;
import java.util.Collections;

public class MixinNode
extends Node
implements NodeWithUrlContent {
    private ActualArgumentList arglist;
    private String name;

    public MixinNode(String uri, int line, int column, String name, ActualArgumentList args) {
        super(uri, line, column);
        this.name = name;
        this.arglist = args;
    }

    private MixinNode(MixinNode nodeToCopy) {
        super(nodeToCopy);
        this.arglist = nodeToCopy.arglist;
        this.name = nodeToCopy.name;
    }

    public ActualArgumentList getArglist() {
        return this.arglist;
    }

    protected void expandVariableArguments() {
        this.arglist = this.arglist.expandVariableArguments();
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String printState() {
        return "name: " + this.getName() + " args: " + this.getArglist();
    }

    public String toString() {
        return "Mixin node [" + this.printState() + "]";
    }

    @Override
    public Collection<Node> traverse(ScssContext context) {
        try {
            this.arglist = this.arglist.evaluateFunctionsAndExpressions(context, true);
            this.expandVariableArguments();
            return MixinNodeHandler.traverse(context, this);
        }
        catch (Exception ex) {
            SCSSErrorHandler.get().error(ex);
            return Collections.emptyList();
        }
    }

    @Override
    public MixinNode copy() {
        return new MixinNode(this);
    }

    @Override
    public NodeWithUrlContent updateUrl(String prefix) {
        MixinNode newInstance = this.copy();
        newInstance.arglist = this.arglist.updateUrl(prefix);
        return newInstance;
    }
}

