/*
 * Decompiled with CFR 0.152.
 */
package com.inet.sass.tree;

import com.inet.sass.ScssContext;
import com.inet.sass.handler.SCSSErrorHandler;
import com.inet.sass.parser.SassListItem;
import com.inet.sass.tree.Node;
import java.util.Collection;
import java.util.Collections;

public class MessageNode
extends Node {
    private SassListItem message;
    private MessageLevel level;

    public MessageNode(SassListItem message, MessageLevel level) {
        this.message = message;
        this.level = level;
    }

    @Override
    public String printState() {
        return "";
    }

    public String toString() {
        return "@" + (Object)((Object)this.level) + ' ' + this.message;
    }

    @Override
    public Collection<Node> traverse(ScssContext context) {
        SCSSErrorHandler handler = SCSSErrorHandler.get();
        this.message = this.message.evaluateFunctionsAndExpressions(context, true);
        String msg = this.message.evaluateFunctionsAndExpressions(context, true).unquotedString();
        switch (this.level) {
            case debug: {
                handler.debug(msg);
                break;
            }
            case warn: {
                handler.warning(msg);
                break;
            }
            case error: {
                handler.error(msg);
            }
        }
        return Collections.emptyList();
    }

    @Override
    public MessageNode copy() {
        return new MessageNode(this.message, this.level);
    }

    public static enum MessageLevel {
        debug,
        warn,
        error;

    }
}

