/*
 * Decompiled with CFR 0.152.
 */
package com.inet.sass.tree;

import com.inet.sass.ScssContext;
import com.inet.sass.parser.MediaList;
import com.inet.sass.tree.BlockNode;
import com.inet.sass.tree.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public class MediaNode
extends Node {
    MediaList media;

    public MediaNode(String uri, int line, int column, MediaList media) {
        super(uri, line, column);
        this.media = media;
    }

    private MediaNode(MediaNode nodeToCopy) {
        super(nodeToCopy);
        this.media = nodeToCopy.media;
    }

    public MediaList getMedia() {
        return this.media;
    }

    public void setMedia(MediaList media) {
        this.media = media;
    }

    @Override
    public String printState() {
        return this.buildString(PRINT_STRATEGY, true);
    }

    public String toString() {
        return this.buildString(TO_STRING_STRATEGY, true);
    }

    @Override
    public Collection<Node> traverse(ScssContext context) {
        if (this.media != null) {
            this.media = this.media.replaceVariables(context);
        }
        if (this.getNormalParentNode() instanceof BlockNode) {
            return Collections.singletonList(this);
        }
        Collection<Node> children = this.traverseChildren(context);
        ArrayList<Node> result = new ArrayList<Node>();
        result.add(this);
        Iterator<Node> it = children.iterator();
        while (it.hasNext()) {
            Node child = it.next();
            if (child.getClass() != MediaNode.class) continue;
            MediaNode mediaChild = (MediaNode)child;
            MediaList medium = new MediaList();
            mediaChild.media.replaceVariables(context);
            medium.addItem(this.media + " and " + mediaChild.media);
            mediaChild.setMedia(medium);
            result.add(child);
            it.remove();
        }
        if (result.size() > 1) {
            if (children.size() == 0) {
                result.remove(0);
            } else {
                this.setChildren(children);
            }
        }
        return result;
    }

    private String buildString(Node.BuildStringStrategy strategy, boolean indent) {
        StringBuilder builder = new StringBuilder("@media ");
        if (this.media != null) {
            for (int i = 0; i < this.media.getLength(); ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(this.media.item(i));
            }
        }
        builder.append(" {\n");
        for (Node child : this.getChildren()) {
            builder.append('\t');
            if (child instanceof BlockNode) {
                if (PRINT_STRATEGY.equals(strategy)) {
                    builder.append(((BlockNode)child).buildString(indent));
                } else {
                    builder.append(strategy.build(child));
                }
            } else {
                builder.append(strategy.build(child));
            }
            builder.append('\n');
        }
        builder.append("}");
        return builder.toString();
    }

    @Override
    public MediaNode copy() {
        return new MediaNode(this);
    }
}

