/*
 * Decompiled with CFR 0.152.
 */
package com.inet.sass.tree;

import com.inet.sass.ScssContext;
import com.inet.sass.parser.StringInterpolationSequence;
import com.inet.sass.tree.Node;
import java.util.Collection;
import java.util.Collections;

public class KeyframesNode
extends Node {
    private String keyframeName;
    private StringInterpolationSequence animationName;

    public KeyframesNode(String keyframeName, StringInterpolationSequence animationName) {
        this.keyframeName = keyframeName;
        this.animationName = animationName;
    }

    private KeyframesNode(KeyframesNode nodeToCopy) {
        super(nodeToCopy);
        this.keyframeName = nodeToCopy.keyframeName;
        this.animationName = nodeToCopy.animationName;
    }

    @Override
    public String printState() {
        return this.buildString(PRINT_STRATEGY);
    }

    public String toString() {
        return "Key frames node [" + this.buildString(TO_STRING_STRATEGY) + "]";
    }

    @Override
    public Collection<Node> traverse(ScssContext context) {
        this.animationName = this.animationName.replaceVariables(context);
        this.traverseChildren(context);
        return Collections.singleton(this);
    }

    private String buildString(Node.BuildStringStrategy strategy) {
        StringBuilder string = new StringBuilder();
        string.append(this.keyframeName).append(" ").append(this.animationName).append(" {\n");
        for (Node child : this.getChildren()) {
            string.append("\t\t").append(strategy.build(child)).append("\n");
        }
        string.append("\t}");
        return string.toString();
    }

    @Override
    public KeyframesNode copy() {
        return new KeyframesNode(this);
    }
}

