/*
 * Decompiled with CFR 0.152.
 */
package com.inet.sass.tree;

import com.inet.sass.ScssContext;
import com.inet.sass.tree.Node;
import java.util.Collection;
import java.util.Collections;

public class KeyframeSelectorNode
extends Node {
    private String selector;

    public KeyframeSelectorNode(String selector) {
        this.selector = selector;
    }

    private KeyframeSelectorNode(KeyframeSelectorNode nodeToCopy) {
        super(nodeToCopy);
        this.selector = nodeToCopy.selector;
    }

    @Override
    public String printState() {
        return this.buildString(PRINT_STRATEGY);
    }

    public String toString() {
        return "Key frame selector node [" + this.buildString(TO_STRING_STRATEGY) + "]";
    }

    @Override
    public Collection<Node> traverse(ScssContext context) {
        this.traverseChildren(context);
        return Collections.singleton(this);
    }

    public String buildString(Node.BuildStringStrategy strategy) {
        StringBuilder string = new StringBuilder();
        string.append(this.selector).append(" {\n");
        for (Node child : this.getChildren()) {
            string.append("\t").append(strategy.build(child)).append("\n");
        }
        string.append("}");
        return string.toString();
    }

    @Override
    public KeyframeSelectorNode copy() {
        return new KeyframeSelectorNode(this);
    }
}

