/*
 * Decompiled with CFR 0.152.
 */
package com.inet.sass.tree;

import com.inet.sass.ScssContext;
import com.inet.sass.parser.MediaList;
import com.inet.sass.tree.Node;
import com.inet.sass.tree.NodeWithUrlContent;
import com.inet.sass.util.StringUtil;
import com.inet.sass.visitor.ImportNodeHandler;
import java.util.Collection;

public class ImportNode
extends Node
implements NodeWithUrlContent {
    private String uri;
    private MediaList ml;
    private boolean isURL;

    public ImportNode(String uri, MediaList ml, boolean isURL) {
        this.uri = uri;
        this.ml = ml;
        this.isURL = isURL;
    }

    private ImportNode(ImportNode nodeToCopy) {
        super(nodeToCopy);
        this.uri = nodeToCopy.uri;
        this.ml = nodeToCopy.ml;
        this.isURL = nodeToCopy.isURL;
    }

    public boolean isPureCssImport() {
        return this.isURL || this.uri.endsWith(".css") || this.uri.startsWith("http://") || this.hasMediaQueries();
    }

    private boolean hasMediaQueries() {
        return this.ml != null && this.ml.getLength() >= 1 && !"all".equals(this.ml.item(0));
    }

    @Override
    public String printState() {
        StringBuilder builder = new StringBuilder("@import ");
        if (this.isURL) {
            builder.append("url(").append(this.uri).append(")");
        } else {
            builder.append("\"").append(this.uri).append("\"");
        }
        if (this.hasMediaQueries()) {
            for (int i = 0; i < this.ml.getLength(); ++i) {
                builder.append(" ").append(this.ml.item(i));
            }
        }
        builder.append(";");
        return builder.toString();
    }

    public String toString() {
        return "Import node [" + this.printState() + "]";
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    @Override
    public Collection<Node> traverse(ScssContext context) {
        return ImportNodeHandler.traverse(context, this);
    }

    @Override
    public ImportNode copy() {
        return new ImportNode(this);
    }

    @Override
    public ImportNode updateUrl(String prefix) {
        if (this.isURL) {
            String newUri = this.getUri().replaceAll("^\"|\"$", "").replaceAll("^'|'$", "");
            if (!newUri.startsWith("/") && !newUri.contains(":")) {
                newUri = prefix + newUri;
                newUri = StringUtil.cleanPath(newUri);
            }
            ImportNode copy = this.copy();
            copy.setUri(newUri);
            return copy;
        }
        return this;
    }
}

