/*
 * Decompiled with CFR 0.152.
 */
package com.inet.sass.tree;

import com.inet.sass.Scope;
import com.inet.sass.ScssContext;
import com.inet.sass.handler.SCSSErrorHandler;
import com.inet.sass.parser.ActualArgumentList;
import com.inet.sass.parser.FormalArgumentList;
import com.inet.sass.parser.LexicalUnitImpl;
import com.inet.sass.parser.ParseException;
import com.inet.sass.parser.SassListItem;
import com.inet.sass.parser.Variable;
import com.inet.sass.tree.FunctionDefNode;
import com.inet.sass.tree.Node;
import com.inet.sass.tree.ReturnNode;
import java.util.ArrayList;

public class FunctionCall {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SassListItem evaluate(ScssContext context, FunctionDefNode def, LexicalUnitImpl invocation) {
        ActualArgumentList invocationArglist = invocation.getParameterList().expandVariableArguments();
        SassListItem value = null;
        Exception cause = null;
        try {
            FormalArgumentList arglist = def.getArglist();
            arglist = arglist.replaceFormalArguments(invocationArglist, true);
            FunctionDefNode defCopy = def.copy();
            Scope previousScope = context.openVariableScope(def.getDefinitionScope());
            try {
                for (Variable arg : arglist) {
                    SassListItem expr = arg.getExpr();
                    if (expr != null) {
                        expr = expr.evaluateFunctionsAndExpressions(context, true);
                    }
                    context.addVariable(new Variable(arg.getName(), expr));
                }
                while (defCopy.getChildren().size() > 0) {
                    Node firstChild = defCopy.getChildren().get(0);
                    if (firstChild instanceof ReturnNode) {
                        ReturnNode returnNode = (ReturnNode)firstChild;
                        value = returnNode.evaluate(context);
                        break;
                    }
                    defCopy.replaceNode(firstChild, new ArrayList<Node>(firstChild.traverse(context)));
                }
            }
            finally {
                context.closeVariableScope(previousScope);
            }
        }
        catch (Exception ex) {
            cause = ex;
            SCSSErrorHandler.get().warning(ex);
        }
        if (value == null) {
            ParseException pex = new ParseException("Function " + invocation.getFunctionName() + " did not return a value", invocation);
            pex.initCause(cause);
            throw pex;
        }
        return value;
    }
}

