/*
 * Decompiled with CFR 0.152.
 */
package com.inet.sass.tree;

import com.inet.sass.ScssContext;
import com.inet.sass.handler.SCSSErrorHandler;
import com.inet.sass.selector.Selector;
import com.inet.sass.tree.Node;
import com.inet.sass.visitor.ExtendNodeHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ExtendNode
extends Node {
    private List<Selector> list;
    private boolean optional;

    public ExtendNode(List<Selector> list, boolean optional) {
        this.list = list;
        this.optional = optional;
    }

    private ExtendNode(ExtendNode nodeToCopy) {
        super(nodeToCopy);
        this.list = new ArrayList<Selector>(nodeToCopy.list);
        this.optional = nodeToCopy.optional;
    }

    public List<Selector> getList() {
        return this.list;
    }

    public String toString() {
        return "Extend node [" + this.getListAsString() + "]";
    }

    public String getListAsString() {
        StringBuilder b = new StringBuilder();
        for (Selector s : this.list) {
            b.append(s.toString());
        }
        return b.toString();
    }

    @Override
    public Collection<Node> traverse(ScssContext context) {
        try {
            List<Selector> list = this.list;
            for (int i = 0; i < list.size(); ++i) {
                list.set(i, list.get(i).replaceVariables(context));
            }
            return ExtendNodeHandler.traverse(context, this);
        }
        catch (Exception e) {
            SCSSErrorHandler.get().error(e);
            return Collections.emptyList();
        }
    }

    @Override
    public ExtendNode copy() {
        return new ExtendNode(this);
    }
}

