/*
 * Decompiled with CFR 0.152.
 */
package com.inet.sass.tree;

import com.inet.sass.Definition;
import com.inet.sass.Scope;
import com.inet.sass.parser.ActualArgumentList;
import com.inet.sass.parser.FormalArgumentList;
import com.inet.sass.tree.Node;
import com.inet.sass.tree.NodeWithUrlContent;

public abstract class DefNode
extends Node
implements Definition,
NodeWithUrlContent {
    private String name;
    private FormalArgumentList arglist;
    private Scope definitionScope;

    public DefNode(String name, FormalArgumentList args) {
        this.name = name;
        this.arglist = args;
    }

    protected DefNode(DefNode nodeToCopy) {
        super(nodeToCopy);
        this.name = nodeToCopy.name;
        this.arglist = nodeToCopy.arglist;
        this.definitionScope = nodeToCopy.definitionScope;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public FormalArgumentList getArglist() {
        return this.arglist;
    }

    public boolean hasVariableArguments() {
        return this.arglist.hasVariableArguments();
    }

    public void replacePossibleArguments(ActualArgumentList actualArgumentList) {
        this.arglist = this.arglist.replaceFormalArguments(actualArgumentList, true);
    }

    public Scope getDefinitionScope() {
        return this.definitionScope;
    }

    protected void setDefinitionScope(Scope scope) {
        this.definitionScope = scope;
    }

    @Override
    public DefNode updateUrl(String prefix) {
        DefNode newInstance = (DefNode)this.copy();
        newInstance.arglist = this.arglist.updateUrl(prefix);
        return newInstance;
    }
}

