/*
 * Decompiled with CFR 0.152.
 */
package com.inet.sass.tree;

import com.inet.sass.ScssContext;
import com.inet.sass.handler.SCSSErrorHandler;
import com.inet.sass.selector.Selector;
import com.inet.sass.tree.Node;
import com.inet.sass.visitor.BlockNodeHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class BlockNode
extends Node {
    private List<Selector> selectorList;
    private List<Selector> parentSelectors;

    public BlockNode(String uri, int line, int column, List<Selector> selectorList) {
        super(uri, line, column);
        this.selectorList = selectorList;
    }

    public BlockNode(BlockNode original, Collection<Node> children) {
        this(original.getUri(), original.getLineNumber(), original.getColumnNumber(), original.getSelectorList());
        this.setChildren(children);
    }

    private BlockNode(BlockNode blockNode) {
        super(blockNode);
        this.selectorList = blockNode.selectorList;
        this.parentSelectors = blockNode.parentSelectors;
    }

    public List<Selector> getSelectorList() {
        return this.selectorList;
    }

    public void setSelectorList(List<Selector> selectorList) {
        this.selectorList = selectorList;
    }

    public String buildString(boolean indent) {
        return this.buildString(indent, PRINT_STRATEGY);
    }

    @Override
    public String printState() {
        return this.buildString(false);
    }

    public String toString() {
        return "BlockNode [" + this.buildString(true, TO_STRING_STRATEGY) + "]";
    }

    private void replaceVariables(ScssContext context) {
        if (this.selectorList == null || this.selectorList.isEmpty()) {
            return;
        }
        ArrayList<Selector> newSelectorList = new ArrayList<Selector>();
        for (Selector s : this.selectorList) {
            newSelectorList.add(s.replaceVariables(context));
        }
        this.setSelectorList(newSelectorList);
    }

    public String getSelectors() {
        StringBuilder b = new StringBuilder();
        for (Selector s : this.selectorList) {
            b.append(s);
        }
        return b.toString();
    }

    @Override
    public Collection<Node> traverse(ScssContext context) {
        try {
            this.replaceVariables(context);
            return BlockNodeHandler.traverse(context, this);
        }
        catch (Exception e) {
            SCSSErrorHandler.get().error(e);
            return Collections.emptyList();
        }
    }

    private String buildString(boolean indent, Node.BuildStringStrategy strategy) {
        StringBuilder string = new StringBuilder();
        int i = 0;
        for (Selector s : this.selectorList) {
            string.append(s);
            if (i != this.selectorList.size() - 1) {
                string.append(", ");
            }
            ++i;
        }
        string.append(" {\n");
        for (Node child : this.getChildren()) {
            if (indent) {
                string.append("\t");
            }
            string.append("\t" + strategy.build(child) + "\n");
        }
        if (indent) {
            string.append("\t");
        }
        string.append("}");
        return string.toString();
    }

    @Override
    public BlockNode copy() {
        return new BlockNode(this);
    }

    public List<Selector> getParentSelectors() {
        return this.parentSelectors;
    }

    public void setParentSelectors(List<Selector> parentSelectors) {
        this.parentSelectors = parentSelectors;
    }
}

