/*
 * Decompiled with CFR 0.152.
 */
package com.inet.sass.selector;

import com.inet.sass.ScssContext;
import com.inet.sass.selector.IdSelector;
import com.inet.sass.selector.ParentSelector;
import com.inet.sass.selector.PlaceholderSelector;
import com.inet.sass.selector.PseudoClassSelector;
import com.inet.sass.selector.PseudoElementSelector;
import com.inet.sass.selector.Selector;
import com.inet.sass.selector.SelectorSegment;
import com.inet.sass.selector.SimpleSelector;
import com.inet.sass.selector.TypeSelector;
import com.inet.sass.selector.UniversalSelector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class SimpleSelectorSequence
implements SelectorSegment {
    private List<SimpleSelector> selectors;

    public SimpleSelectorSequence(List<SimpleSelector> seq) {
        this.selectors = seq;
    }

    public SimpleSelectorSequence difference(SimpleSelectorSequence that) {
        ArrayList<SimpleSelector> result = new ArrayList<SimpleSelector>(this.selectors);
        result.removeAll(that.selectors);
        return new SimpleSelectorSequence(result);
    }

    public SimpleSelectorSequence union(SimpleSelectorSequence that) {
        ArrayList<SimpleSelector> union = new ArrayList<SimpleSelector>(this.selectors);
        ArrayList<SimpleSelector> newEntries = new ArrayList<SimpleSelector>(that.selectors);
        newEntries.removeAll(this.selectors);
        union.addAll(newEntries);
        SimpleSelectorSequence.ensureOrdering(union);
        return new SimpleSelectorSequence(union);
    }

    private static void ensureOrdering(List<SimpleSelector> list) {
        Comparator<SimpleSelector> c = new Comparator<SimpleSelector>(){

            public int getOrdinal(SimpleSelector it) {
                if (it instanceof TypeSelector) {
                    return -1;
                }
                if (it instanceof PseudoElementSelector) {
                    return 3;
                }
                if (it instanceof PseudoClassSelector) {
                    return 2;
                }
                return 0;
            }

            @Override
            public int compare(SimpleSelector it, SimpleSelector that) {
                return this.getOrdinal(it) - this.getOrdinal(that);
            }
        };
        Collections.sort(list, c);
    }

    public SimpleSelectorSequence unify(SimpleSelectorSequence extend, SimpleSelectorSequence extending) {
        if (extend != null && extend.subsumes(this)) {
            if (extend.getTypeSelector() == null && extending.getTypeSelector() != null && this.getTypeSelector() != null && !extending.getTypeSelector().equals(this.getTypeSelector())) {
                return null;
            }
            SimpleSelectorSequence retval = this.difference(extend).union(extending);
            if (retval.cannotMatchAnything()) {
                return null;
            }
            return retval;
        }
        return null;
    }

    private boolean cannotMatchAnything() {
        IdSelector id = null;
        for (SimpleSelector s : this.selectors) {
            if (!(s instanceof IdSelector)) continue;
            if (id == null) {
                id = (IdSelector)s;
                continue;
            }
            if (id.equals(s)) continue;
            return true;
        }
        return false;
    }

    SimpleSelectorSequence replaceParentReference(Selector replacement) {
        List<SimpleSelector> selectors = this.selectors;
        boolean parentFound = false;
        for (int i = selectors.size() - 1; i >= 0; --i) {
            SimpleSelector sel = selectors.get(i);
            if (sel != ParentSelector.it) continue;
            if (!parentFound) {
                parentFound = true;
                selectors = new ArrayList<SimpleSelector>(selectors);
            }
            selectors.remove(i);
            if (replacement == null) continue;
            selectors.addAll(i, replacement.lastSimple().selectors);
        }
        if (parentFound) {
            return new SimpleSelectorSequence(selectors);
        }
        return this;
    }

    public TypeSelector getTypeSelector() {
        SimpleSelector head = this.selectors.get(0);
        return head instanceof TypeSelector ? (TypeSelector)head : null;
    }

    private List<SimpleSelector> getNonTypeSelectorList() {
        SimpleSelector head = this.selectors.get(0);
        if (head instanceof TypeSelector) {
            return this.selectors.subList(1, this.selectors.size());
        }
        return this.selectors;
    }

    public boolean subsumes(SimpleSelectorSequence that) {
        TypeSelector ts = this.getTypeSelector();
        if (ts == null || ts.equals(UniversalSelector.it)) {
            return that.getNonTypeSelectorList().containsAll(this.getNonTypeSelectorList());
        }
        return that.selectors.containsAll(this.selectors);
    }

    public SimpleSelectorSequence replaceVariables(ScssContext context) {
        ArrayList<SimpleSelector> list = new ArrayList<SimpleSelector>();
        for (SimpleSelector s : this.selectors) {
            list.add(s.replaceVariables(context));
        }
        return new SimpleSelectorSequence(list);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (SimpleSelector s : this.selectors) {
            sb.append(s.toString());
        }
        return sb.toString();
    }

    public boolean isPlaceholder() {
        for (SimpleSelector s : this.selectors) {
            if (!(s instanceof PlaceholderSelector)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        return this.selectors.equals(((SimpleSelectorSequence)obj).selectors);
    }

    public int hashCode() {
        return this.selectors.hashCode();
    }
}

