/*
 * Decompiled with CFR 0.152.
 */
package com.inet.sass.selector;

import com.inet.sass.ScssContext;
import com.inet.sass.selector.Combinator;
import com.inet.sass.selector.SelectorSegment;
import com.inet.sass.selector.SimpleSelectorSequence;
import com.inet.sass.visitor.Extension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Selector {
    private List<SelectorSegment> parts = new ArrayList<SelectorSegment>();

    private Selector() {
    }

    public Selector(Selector source) {
        this(source.parts);
    }

    protected Selector(List<SelectorSegment> parts) {
        this.parts.addAll(parts);
    }

    public Selector(SimpleSelectorSequence simple) {
        this.parts.add(simple);
    }

    public Selector(Combinator comb, SimpleSelectorSequence simpl) {
        this.parts.add(comb);
        this.parts.add(simpl);
    }

    public Selector(Selector first, Combinator comb, Selector second) {
        assert (comb == null && first == null || comb != null && first != null);
        if (first != null) {
            this.parts.addAll(first.parts);
            this.parts.add(comb);
        }
        this.parts.addAll(second.parts);
    }

    private boolean hasLeadingCombinator() {
        return this.parts.size() > 0 && this.parts.get(0) instanceof Combinator;
    }

    public boolean isSimple() {
        return this.parts.size() == 1 && this.parts.get(0).getClass() == SimpleSelectorSequence.class;
    }

    public SimpleSelectorSequence firstSimple() {
        for (SelectorSegment segment : this.parts) {
            if (!(segment instanceof SimpleSelectorSequence)) continue;
            return (SimpleSelectorSequence)segment;
        }
        return null;
    }

    SimpleSelectorSequence lastSimple() {
        return (SimpleSelectorSequence)this.parts.get(this.parts.size() - 1);
    }

    private Selector tail() {
        if (this.parts.size() > 2) {
            return new Selector(this.parts.subList(2, this.parts.size()));
        }
        return null;
    }

    public boolean subsumes(Selector that) {
        if (that.equals(this)) {
            return true;
        }
        if (this.hasLeadingCombinator() || that.hasLeadingCombinator()) {
            return false;
        }
        if (this.parts.size() > that.parts.size()) {
            return false;
        }
        if (this.isSimple()) {
            return this.firstSimple().subsumes(that.lastSimple());
        }
        assert (this.parts.size() > 2);
        assert (this.parts.size() <= that.parts.size());
        if (this.firstSimple().subsumes(that.firstSimple())) {
            return this.tail().subsumes(that.tail());
        }
        return false;
    }

    public Selector replaceParentReference(Selector replacement) {
        boolean foundParentReference = false;
        Selector sel = new Selector();
        for (int i = 0; i < this.parts.size(); ++i) {
            SelectorSegment segment = this.parts.get(i);
            if (segment instanceof SimpleSelectorSequence) {
                SimpleSelectorSequence simple = (SimpleSelectorSequence)segment;
                SimpleSelectorSequence replacedSimple = simple.replaceParentReference(replacement);
                if (simple != replacedSimple) {
                    foundParentReference = true;
                    if (replacement != null) {
                        List<SelectorSegment> replacemnetParts = replacement.parts;
                        int count = replacemnetParts.size() - 1;
                        for (int j = 0; j < count; ++j) {
                            sel.parts.add(replacemnetParts.get(j));
                        }
                    }
                    sel.parts.add(replacedSimple);
                    continue;
                }
                sel.parts.add(simple);
                continue;
            }
            sel.parts.add(segment);
        }
        if (foundParentReference) {
            return sel;
        }
        if (replacement != null) {
            return new Selector(replacement, Combinator.DESCENDANT, this);
        }
        return this;
    }

    public Selector replaceVariables(ScssContext context) {
        Selector sel = new Selector();
        for (SelectorSegment segment : this.parts) {
            if (segment instanceof SimpleSelectorSequence) {
                SimpleSelectorSequence seq = (SimpleSelectorSequence)segment;
                seq = seq.replaceVariables(context);
                sel.parts.add(seq);
                continue;
            }
            sel.parts.add(segment);
        }
        return sel;
    }

    public Selector createNested(Combinator c, SimpleSelectorSequence s) {
        Selector ext = new Selector();
        ext.parts.addAll(this.parts);
        ext.parts.add(c);
        ext.parts.add(s);
        return ext;
    }

    public Selector replace(Extension extension) {
        Selector sel = new Selector();
        ArrayList<SelectorSegment> previousSegments = new ArrayList<SelectorSegment>();
        for (SelectorSegment segment : this.parts) {
            if (segment instanceof SimpleSelectorSequence && extension.extendSelector.equals(segment)) {
                Selector newExtending = extension.replacingSelector.removePrefix((List<SelectorSegment>)previousSegments);
                if (extension.context != null) {
                    newExtending = newExtending.removePrefix(extension.context);
                }
                sel.parts.addAll(newExtending.parts);
                previousSegments = null;
                continue;
            }
            if (previousSegments != null) {
                previousSegments.add(segment);
            }
            sel.parts.add(segment);
        }
        if (sel.parts.size() == 0) {
            return sel;
        }
        assert (sel.parts.get(sel.parts.size() - 1) instanceof SimpleSelectorSequence);
        SimpleSelectorSequence seq = sel.lastSimple();
        SimpleSelectorSequence lastUnified = seq.unify(extension.extendSelector, extension.replacingSelector.lastSimple());
        if (lastUnified != null) {
            sel.parts.remove(sel.parts.size() - 1);
            sel.parts.addAll(extension.replacingSelector.parts);
            sel.parts.set(sel.parts.size() - 1, lastUnified);
        }
        return sel;
    }

    private Selector removePrefix(List<SelectorSegment> toRemove) {
        if (toRemove == null || this.parts.size() < toRemove.size()) {
            return this;
        }
        for (int i = 0; i < toRemove.size(); ++i) {
            if (this.parts.get(i).equals(toRemove.get(i))) continue;
            return this;
        }
        return new Selector(this.parts.subList(toRemove.size(), this.parts.size()));
    }

    private Selector removePrefix(Collection<Selector> toRemove) {
        for (Selector sel : toRemove) {
            if (!this.hasPrefix(sel)) continue;
            return this.removePrefix(sel.parts);
        }
        return this;
    }

    private boolean hasPrefix(Selector prefix) {
        if (this.parts.size() < prefix.parts.size()) {
            return false;
        }
        for (int i = 0; i < prefix.parts.size(); ++i) {
            if (this.parts.get(i).equals(prefix.parts.get(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (SelectorSegment segment : this.parts) {
            sb.append(segment.toString());
        }
        return sb.toString();
    }

    public boolean equals(Object that) {
        if (!(that instanceof Selector)) {
            return false;
        }
        Selector thatSelector = (Selector)that;
        return this.parts.equals(thatSelector.parts);
    }

    public int hashCode() {
        return this.parts.hashCode();
    }

    public boolean isPlaceholder() {
        for (SelectorSegment segment : this.parts) {
            if (!(segment instanceof SimpleSelectorSequence) || !((SimpleSelectorSequence)segment).isPlaceholder()) continue;
            return true;
        }
        return false;
    }
}

