/*
 * Decompiled with CFR 0.152.
 */
package com.inet.sass.selector;

import com.inet.sass.ScssContext;
import com.inet.sass.parser.StringInterpolationSequence;
import com.inet.sass.selector.SimpleSelector;

public class AttributeSelector
extends SimpleSelector {
    private StringInterpolationSequence attribute;
    private MatchRelation matchRelation;
    private StringInterpolationSequence value;

    public AttributeSelector(StringInterpolationSequence attribute, MatchRelation matchRelation, StringInterpolationSequence value) {
        this.attribute = attribute;
        this.matchRelation = matchRelation;
        this.value = value;
    }

    public String getAttribute() {
        return this.attribute.toString();
    }

    public MatchRelation getMatchRelation() {
        return this.matchRelation;
    }

    private StringInterpolationSequence getValue() {
        return this.value;
    }

    public String toString() {
        if (this.getValue() == null) {
            return "[" + this.getAttribute() + "]";
        }
        return "[" + this.getAttribute() + (Object)((Object)this.getMatchRelation()) + this.getValue() + "]";
    }

    @Override
    public AttributeSelector replaceVariables(ScssContext context) {
        StringInterpolationSequence newAttribute = this.attribute.replaceVariables(context);
        StringInterpolationSequence newValue = null;
        if (this.value != null) {
            newValue = this.value.replaceVariables(context);
        }
        return new AttributeSelector(newAttribute, this.matchRelation, newValue);
    }

    public static enum MatchRelation {
        EQUALS("="),
        INCLUDES("~="),
        DASHMATCH("|="),
        PREFIXMATCH("^="),
        SUFFIXMATCH("$="),
        SUBSTRINGMATCH("*=");

        private String value;

        private MatchRelation(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

