/*
 * Decompiled with CFR 0.152.
 */
package com.inet.sass.resolver;

import com.inet.sass.InputSource;
import com.inet.sass.ScssStylesheet;
import com.inet.sass.resolver.AbstractResolver;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.List;

public class FilesystemResolver
extends AbstractResolver {
    private Charset cs;
    private String[] customPaths;

    public FilesystemResolver(Charset cs, String ... customPaths) {
        this.cs = cs;
        this.customPaths = customPaths;
    }

    @Override
    protected List<String> getPotentialParentPaths(ScssStylesheet parentStyleSheet, String identifier) {
        List<String> potentialPaths = super.getPotentialParentPaths(parentStyleSheet, identifier);
        if (this.customPaths != null) {
            for (String path : this.customPaths) {
                potentialPaths.add(this.extractFullPath(path, identifier));
            }
        }
        return potentialPaths;
    }

    @Override
    public InputSource resolveNormalized(String identifier) {
        String fileName = identifier;
        if (!fileName.endsWith(".css") && !fileName.endsWith(".png")) {
            fileName = fileName + ".scss";
        }
        try {
            FileInputStream is = new FileInputStream(fileName);
            InputSource source = new InputSource();
            source.setByteStream(is);
            source.setCharacterStream(new BufferedReader(new InputStreamReader((InputStream)is, this.cs)));
            source.setURI(fileName);
            return source;
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }
}

