/*
 * Decompiled with CFR 0.152.
 */
package com.inet.sass.resolver;

import com.inet.sass.InputSource;
import com.inet.sass.ScssStylesheet;
import com.inet.sass.resolver.ScssStylesheetResolver;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public abstract class AbstractResolver
implements ScssStylesheetResolver {
    @Override
    public InputSource resolve(ScssStylesheet parentStylesheet, String identifier) {
        identifier = identifier.replaceFirst(".scss$", "");
        List<String> potentialParentPaths = this.getPotentialParentPaths(parentStylesheet, identifier);
        if (identifier.contains("/")) {
            identifier = identifier.substring(identifier.lastIndexOf("/") + 1);
        }
        for (String path : potentialParentPaths) {
            InputSource source = this.normalizeAndResolve(path + "/" + identifier);
            if (source != null) {
                return source;
            }
            source = this.normalizeAndResolve(path + "/_" + identifier);
            if (source == null) continue;
            return source;
        }
        return this.normalizeAndResolve(identifier);
    }

    protected List<String> getPotentialParentPaths(ScssStylesheet parentStylesheet, String identifier) {
        ArrayList<String> potentialParents = new ArrayList<String>();
        if (parentStylesheet != null) {
            potentialParents.add(this.extractFullPath(parentStylesheet.getDirectory(), identifier));
        }
        if (identifier.contains("/")) {
            potentialParents.add(this.extractFullPath("", identifier));
        }
        return potentialParents;
    }

    protected String extractFullPath(String path, String identifier) {
        int lastSlashPosition = identifier.lastIndexOf("/");
        if (lastSlashPosition == -1) {
            return path;
        }
        String identifierPath = identifier.substring(0, lastSlashPosition);
        if ("".equals(path)) {
            return identifierPath;
        }
        return path + "/" + identifierPath;
    }

    protected InputSource normalizeAndResolve(String identifier) {
        String normalized = this.normalize(identifier);
        return this.resolveNormalized(normalized);
    }

    protected abstract InputSource resolveNormalized(String var1);

    protected String normalize(String path) {
        path = path.replace(File.separatorChar, '/');
        String[] segments = path.split("/");
        Stack<String> result = new Stack<String>();
        for (int i = 0; i < segments.length; ++i) {
            if (segments[i].equals(".")) continue;
            if (segments[i].equals("..") && !result.isEmpty() && !((String)result.lastElement()).equals("..")) {
                result.pop();
                continue;
            }
            result.push(segments[i]);
        }
        StringBuilder pathBuilder = new StringBuilder();
        for (int i = 0; i < result.size(); ++i) {
            if (i > 0) {
                pathBuilder.append("/");
            }
            pathBuilder.append((String)result.get(i));
        }
        return pathBuilder.toString();
    }
}

