/*
 * Decompiled with CFR 0.152.
 */
package com.inet.sass.parser;

import com.inet.sass.ScssContext;
import com.inet.sass.parser.SassList;
import com.inet.sass.parser.SassListItem;
import com.inet.sass.parser.StringItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class StringInterpolationSequence {
    private boolean containsInterpolation;
    private List<SassListItem> items;
    private String toString;

    public StringInterpolationSequence(String value) {
        this.items = Collections.singletonList(new StringItem(value));
    }

    public StringInterpolationSequence(List<SassListItem> sequence) {
        for (SassListItem item : sequence) {
            if (item.getItemType() != 112) continue;
            this.containsInterpolation = true;
            break;
        }
        this.items = sequence;
    }

    public StringInterpolationSequence replaceVariables(ScssContext context) {
        if (!this.containsInterpolation) {
            return this;
        }
        return new StringInterpolationSequence(SassList.replaceVariables(context, this.items));
    }

    public StringInterpolationSequence append(StringInterpolationSequence other) {
        ArrayList<SassListItem> result = new ArrayList<SassListItem>(this.items);
        result.addAll(other.items);
        return new StringInterpolationSequence(result);
    }

    public String toString() {
        if (this.toString == null) {
            List<SassListItem> items = this.items;
            if (items.size() == 1) {
                return items.get(0).printState();
            }
            StringBuilder result = new StringBuilder();
            for (SassListItem item : items) {
                result.append(item.printState());
            }
            this.toString = result.toString();
        }
        return this.toString;
    }

    public boolean containsInterpolation() {
        return this.containsInterpolation;
    }

    public List<SassListItem> getItems() {
        return this.items;
    }

    public StringInterpolationSequence updateUrl(String prefix) {
        if (this.containsInterpolation) {
            return new StringInterpolationSequence(SassList.updateUrl(this.items, prefix));
        }
        return this;
    }
}

