/*
 * Decompiled with CFR 0.152.
 */
package com.inet.sass.parser;

import com.inet.sass.InputSource;
import com.inet.sass.handler.SCSSDocumentHandler;
import com.inet.sass.parser.ActualArgumentList;
import com.inet.sass.parser.FormalArgumentList;
import com.inet.sass.parser.Interpolation;
import com.inet.sass.parser.LexicalUnitImpl;
import com.inet.sass.parser.MediaList;
import com.inet.sass.parser.ParseException;
import com.inet.sass.parser.SassExpression;
import com.inet.sass.parser.SassList;
import com.inet.sass.parser.SassListItem;
import com.inet.sass.parser.ScssLookAheadReader;
import com.inet.sass.parser.StringInterpolationSequence;
import com.inet.sass.parser.StringItem;
import com.inet.sass.parser.Variable;
import com.inet.sass.selector.AttributeSelector;
import com.inet.sass.selector.ClassSelector;
import com.inet.sass.selector.Combinator;
import com.inet.sass.selector.IdSelector;
import com.inet.sass.selector.ParentSelector;
import com.inet.sass.selector.PlaceholderSelector;
import com.inet.sass.selector.PseudoClassSelector;
import com.inet.sass.selector.PseudoElementSelector;
import com.inet.sass.selector.Selector;
import com.inet.sass.selector.SimpleSelector;
import com.inet.sass.selector.SimpleSelectorSequence;
import com.inet.sass.selector.TypeSelector;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ScssParser {
    private SCSSDocumentHandler documentHandler;
    private InputSource source;
    private String uri;
    private ScssLookAheadReader reader;
    private boolean wasDefault;
    private boolean wasOptional;
    private final StringBuilder cachesBuilder = new StringBuilder();
    private List<SassListItem> stringSequence;

    public void parseStyleSheet(SCSSDocumentHandler documentHandler, InputSource source) throws IOException {
        this.documentHandler = documentHandler;
        this.source = source;
        this.uri = source.getURI();
        Reader stream = source.getCharacterStream();
        if (stream == null) {
            stream = new InputStreamReader(source.getByteStream(), StandardCharsets.UTF_8);
        }
        try {
            this.reader = new ScssLookAheadReader(stream, source.getURI());
            this.parse(true);
        }
        catch (ParseException ex) {
            throw ex;
        }
        catch (Throwable th) {
            throw this.reader.createException(th);
        }
        finally {
            stream.close();
        }
    }

    private void parse(boolean isRoot) {
        block7: while (true) {
            int ch = this.reader.nextBlockMarker();
            switch (ch) {
                case -1: {
                    if (isRoot) {
                        return;
                    }
                    throw this.reader.createException("Unexpected end of Scss data");
                }
                case 59: {
                    this.parseSemicolon();
                    continue block7;
                }
                case 58: {
                    this.parseNestedProperties();
                    continue block7;
                }
                case 123: {
                    this.parseBlock();
                    continue block7;
                }
                case 125: {
                    if (isRoot) break block7;
                    this.parseSemicolon();
                    this.consumeMarker('}');
                    return;
                }
            }
            break;
        }
        throw this.reader.createException("Unrecognized input: '" + this.reader.getLookAhead() + "'");
    }

    private void parseSemicolon() {
        boolean isVariable = false;
        StringBuilder builder = this.cachesBuilder;
        block10: while (true) {
            char ch;
            try {
                ch = this.reader.read();
            }
            catch (Exception e) {
                ch = ';';
            }
            if (ScssParser.isWhitespace(ch)) {
                if (builder.length() == 0) continue;
                if (builder.charAt(0) == '@') {
                    this.parseAtRule(ScssParser.trim(builder), false);
                    return;
                }
                builder.append(ch);
                continue;
            }
            switch (ch) {
                case ':': {
                    if (isVariable) {
                        String name = ScssParser.trim(builder);
                        this.wasDefault = false;
                        SassListItem exp = this.parseExpressionOrList();
                        this.documentHandler.variable(name, exp, this.wasDefault);
                    } else {
                        StringInterpolationSequence name = this.createStringInterpolationSequence(ScssParser.trim(builder));
                        SassListItem exp = this.parseExpressionOrList();
                        boolean important = false;
                        this.documentHandler.property(name, exp, important, null);
                    }
                    if (this.consumeMarkers(';', '}') == '}') {
                        this.reader.back('}');
                    }
                    return;
                }
                case '$': {
                    isVariable = true;
                    continue block10;
                }
                case '}': {
                    this.reader.back(ch);
                }
                case ';': {
                    if (builder.length() == 0) {
                        return;
                    }
                    if (builder.charAt(0) == '@') {
                        this.reader.back(ch);
                        this.parseAtRule(ScssParser.trim(builder), false);
                        return;
                    }
                    throw this.reader.createException("Unrecognized input: '" + builder + "'");
                }
                case '/': {
                    if (!this.comment()) break;
                    continue block10;
                }
                case '#': {
                    if (this.parseInterpolation(builder)) continue block10;
                    break;
                }
            }
            builder.append(ch);
        }
    }

    private void parseBlock() {
        char ch;
        block4: while (true) {
            ch = this.readNonWhitespace();
            switch (ch) {
                case '/': {
                    if (!this.comment()) break block4;
                    continue block4;
                }
                case '@': {
                    this.parseAtRule('@' + this.parseName(false), true);
                    return;
                }
            }
            break;
        }
        this.reader.back(ch);
        List<Selector> selectorList = this.parseSelectorList(false);
        this.consumeMarker('{');
        this.documentHandler.startSelector(this.source.getURI(), this.reader.getLine(), this.reader.getColumn(), selectorList);
        this.parse(false);
        this.documentHandler.endSelector();
    }

    private void parseNestedProperties() {
        StringInterpolationSequence name = this.parseStringInterpolationSequence(false);
        this.consumeMarker(':');
        this.consumeMarker('{');
        this.documentHandler.startNestedProperties(name);
        this.parse(false);
        this.documentHandler.endNestedProperties();
    }

    private List<Selector> parseSelectorList(boolean extendRule) {
        StringBuilder builder = this.cachesBuilder;
        ArrayList<Selector> selList = new ArrayList<Selector>();
        int type = 32;
        Combinator combiner = null;
        Selector selector = null;
        ArrayList<SimpleSelector> list = new ArrayList<SimpleSelector>();
        block16: while (true) {
            char ch;
            if (ScssParser.isWhitespace(ch = this.reader.read())) {
                this.appendSelector(list, type, builder, extendRule);
                type = 32;
                if (list.size() <= 0) continue;
                selector = this.appendSelector(selector, combiner, list);
                combiner = Combinator.DESCENDANT;
                continue;
            }
            switch (ch) {
                case '+': 
                case '>': 
                case '~': {
                    this.appendSelector(list, type, builder, extendRule);
                    type = 32;
                    if (list.size() > 0) {
                        selector = this.appendSelector(selector, combiner, list);
                    }
                    switch (ch) {
                        case '>': {
                            combiner = Combinator.CHILD;
                            break;
                        }
                        case '+': {
                            combiner = Combinator.SIBLING;
                            break;
                        }
                        case '~': {
                            combiner = Combinator.GENERAL_SIBLING;
                        }
                    }
                    continue block16;
                }
                case ';': 
                case '{': 
                case '}': {
                    this.appendSelector(list, type, builder, extendRule);
                    if (list.size() > 0 || selector == null) {
                        selector = this.appendSelector(selector, combiner, list);
                    }
                    selList.add(selector);
                    this.reader.back(ch);
                    return selList;
                }
                case ',': {
                    this.appendSelector(list, type, builder, extendRule);
                    type = 32;
                    if (list.size() > 0 || selector == null) {
                        selector = this.appendSelector(selector, combiner, list);
                    }
                    selList.add(selector);
                    selector = null;
                    combiner = null;
                    continue block16;
                }
                case '/': {
                    this.comment();
                    continue block16;
                }
                case '&': {
                    this.appendSelector(list, type, builder, extendRule);
                    type = 32;
                    list.add(ParentSelector.it);
                    continue block16;
                }
                case '#': {
                    if (this.parseInterpolation(builder)) continue block16;
                }
                case '%': 
                case '.': {
                    if (!this.isNextIdentifierPart()) break;
                    this.appendSelector(list, type, builder, extendRule);
                    type = ch;
                    continue block16;
                }
                case '[': {
                    this.appendSelector(list, type, builder, extendRule);
                    type = 32;
                    list.add(this.parseAttributeSelector());
                    continue block16;
                }
                case ':': {
                    this.appendSelector(list, type, builder, extendRule);
                    ch = this.reader.read();
                    if (':' == ch) {
                        type = ch;
                        continue block16;
                    }
                    this.reader.back(ch);
                    type = 32;
                    list.add(this.parsePseudoClassSelector());
                    continue block16;
                }
            }
            builder.append(ch);
        }
    }

    private void appendSelector(List<SimpleSelector> list, int type, StringBuilder builder, boolean extendRule) {
        if (extendRule && "!optional".contentEquals(builder)) {
            this.wasOptional = true;
            builder.setLength(0);
        }
        if (this.stringSequence != null || builder.length() > 0 || type != 32) {
            SimpleSelector sel;
            StringInterpolationSequence value = this.createStringInterpolationSequence(builder);
            switch (type) {
                case 37: {
                    sel = new PlaceholderSelector(value);
                    break;
                }
                case 46: {
                    sel = new ClassSelector(value);
                    break;
                }
                case 35: {
                    sel = new IdSelector(value);
                    break;
                }
                case 58: {
                    sel = new PseudoElementSelector(value);
                    break;
                }
                default: {
                    sel = new TypeSelector(value);
                }
            }
            list.add(sel);
        }
    }

    private Selector appendSelector(Selector selector, Combinator combiner, List<SimpleSelector> list) {
        SimpleSelectorSequence selSequence = new SimpleSelectorSequence(new ArrayList<SimpleSelector>(list));
        list.clear();
        if (selector == null) {
            return combiner == null ? new Selector(selSequence) : new Selector(combiner, selSequence);
        }
        if (combiner == null) {
            combiner = Combinator.DESCENDANT;
        }
        return selector.createNested(combiner, selSequence);
    }

    private AttributeSelector parseAttributeSelector() {
        AttributeSelector.MatchRelation matchRelation;
        StringInterpolationSequence attribute = this.parseStringInterpolationSequence(false);
        char ch = this.reader.read();
        switch (ch) {
            case '=': {
                matchRelation = AttributeSelector.MatchRelation.EQUALS;
                break;
            }
            case '|': {
                matchRelation = AttributeSelector.MatchRelation.DASHMATCH;
                this.consumeMarker('=');
                break;
            }
            case '^': {
                matchRelation = AttributeSelector.MatchRelation.PREFIXMATCH;
                this.consumeMarker('=');
                break;
            }
            case '$': {
                matchRelation = AttributeSelector.MatchRelation.SUFFIXMATCH;
                this.consumeMarker('=');
                break;
            }
            case '*': {
                matchRelation = AttributeSelector.MatchRelation.SUBSTRINGMATCH;
                this.consumeMarker('=');
                break;
            }
            case '~': {
                matchRelation = AttributeSelector.MatchRelation.INCLUDES;
                this.consumeMarker('=');
                break;
            }
            case ']': {
                matchRelation = null;
                this.reader.back(ch);
                break;
            }
            default: {
                throw this.reader.createException("Unrecognized input: '" + ch + "'");
            }
        }
        StringInterpolationSequence value = matchRelation == null ? null : this.parseStringInterpolationSequence(false);
        this.consumeMarker(']');
        return new AttributeSelector(attribute, matchRelation, value);
    }

    private PseudoClassSelector parsePseudoClassSelector() {
        StringInterpolationSequence argument;
        StringInterpolationSequence pseudoClass = this.parseStringInterpolationSequence(false);
        char ch = this.reader.read();
        if (ch == '(') {
            argument = this.parseStringInterpolationSequence(true);
            this.consumeMarker(')');
        } else {
            argument = null;
            this.reader.back(ch);
        }
        return new PseudoClassSelector(pseudoClass, argument);
    }

    /*
     * Enabled aggressive block sorting
     */
    private MediaList mediaStatement() {
        StringBuilder builder = this.cachesBuilder;
        MediaList ml = new MediaList();
        block5: while (true) {
            char ch = this.reader.read();
            switch (ch) {
                case ';': 
                case '{': {
                    if (this.stringSequence == null) {
                        ml.addItem(ScssParser.trim(builder));
                    } else {
                        ml.addItem(this.createStringInterpolationSequence(builder));
                    }
                    this.reader.back(ch);
                    return ml;
                }
                case '#': {
                    if (this.parseInterpolation(builder)) continue block5;
                    break;
                }
                case '$': {
                    List<SassListItem> sequence = this.stringSequence;
                    if (sequence == null) {
                        sequence = this.stringSequence = new ArrayList<SassListItem>();
                    }
                    if (builder.length() > 0) {
                        sequence.add(new StringItem(ScssParser.str(builder)));
                    }
                    int line = this.reader.getLine();
                    int column = this.reader.getColumn();
                    LexicalUnitImpl item = LexicalUnitImpl.createVariable(this.uri, line, column, this.parseName(false));
                    sequence.add(new Interpolation(item, line, column));
                    continue block5;
                }
            }
            builder.append(ch);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void parseAtRule(String rule, boolean block) {
        block59: while (true) {
            var4_4 = rule;
            var5_5 = -1;
            switch (var4_4.hashCode()) {
                case 609786124: {
                    if (!var4_4.equals("@charset")) break;
                    var5_5 = 0;
                    break;
                }
                case -219135003: {
                    if (!var4_4.equals("@import")) break;
                    var5_5 = 1;
                    break;
                }
                case 1813285992: {
                    if (!var4_4.equals("@include")) break;
                    var5_5 = 2;
                    break;
                }
                case -323383462: {
                    if (!var4_4.equals("@extend")) break;
                    var5_5 = 3;
                    break;
                }
                case 1936176193: {
                    if (!var4_4.equals("@mixin")) break;
                    var5_5 = 4;
                    break;
                }
                case 64861: {
                    if (!var4_4.equals("@if")) break;
                    var5_5 = 5;
                    break;
                }
                case 62221689: {
                    if (!var4_4.equals("@else")) break;
                    var5_5 = 6;
                    break;
                }
                case -1278440229: {
                    if (!var4_4.equals("@font-face")) break;
                    var5_5 = 7;
                    break;
                }
                case 1667970072: {
                    if (!var4_4.equals("@function")) break;
                    var5_5 = 8;
                    break;
                }
                case 31264112: {
                    if (!var4_4.equals("@return")) break;
                    var5_5 = 9;
                    break;
                }
                case 822242361: {
                    if (!var4_4.equals("@content")) break;
                    var5_5 = 10;
                    break;
                }
                case 62210625: {
                    if (!var4_4.equals("@each")) break;
                    var5_5 = 11;
                    break;
                }
                case 2008201: {
                    if (!var4_4.equals("@for")) break;
                    var5_5 = 12;
                    break;
                }
                case 1945367281: {
                    if (!var4_4.equals("@while")) break;
                    var5_5 = 13;
                    break;
                }
                case 1936037796: {
                    if (!var4_4.equals("@media")) break;
                    var5_5 = 14;
                    break;
                }
                case -1138628731: {
                    if (!var4_4.equals("@keyframes")) break;
                    var5_5 = 15;
                    break;
                }
                case -1638716285: {
                    if (!var4_4.equals("@-moz-keyframes")) break;
                    var5_5 = 16;
                    break;
                }
                case 617854426: {
                    if (!var4_4.equals("@-o-keyframes")) break;
                    var5_5 = 17;
                    break;
                }
                case 42653863: {
                    if (!var4_4.equals("@-webkit-keyframes")) break;
                    var5_5 = 18;
                    break;
                }
                case 680051915: {
                    if (!var4_4.equals("@-ms-keyframes")) break;
                    var5_5 = 19;
                    break;
                }
                case 1927724563: {
                    if (!var4_4.equals("@debug")) break;
                    var5_5 = 20;
                    break;
                }
                case 62747334: {
                    if (!var4_4.equals("@warn")) break;
                    var5_5 = 21;
                    break;
                }
                case 1929050568: {
                    if (!var4_4.equals("@error")) break;
                    var5_5 = 22;
                }
            }
            switch (var5_5) {
                case 0: {
                    encoding = this.parseQuotedString(this.consumeMarkers('\'', '\"'));
                    this.consumeMarker(';');
                    this.documentHandler.getStyleSheet().setCharset(encoding);
                    return;
                }
                case 1: {
                    ch = this.readNonWhitespace();
                    switch (ch) {
                        case '\"': 
                        case '\'': {
                            uri = this.parseQuotedString(ch);
                            isURL = false;
                            ml = null;
                            break;
                        }
                        case 'u': {
                            ch2 = this.reader.read();
                            ch3 = this.reader.read();
                            if (ch2 != 'r' || ch3 != 'l') {
                                throw this.reader.createException("Unrecognized input: '" + ch + ch2 + ch3 + "'");
                            }
                            this.consumeMarker('(');
                            uri = this.parseUnquotedString();
                            isURL = true;
                            ml = this.mediaStatement();
                            if (ml.getLength() != 0) break;
                            ml.addItem("all");
                            break;
                        }
                        default: {
                            throw this.reader.createException("Unrecognized input: '" + ch + "'");
                        }
                    }
                    this.consumeMarker(';');
                    this.documentHandler.importStyle(uri, ml, isURL);
                    return;
                }
                case 2: {
                    name = this.parseName(true);
                    ch = this.readNonWhitespace();
                    switch (ch) {
                        default: {
                            this.reader.back(ch);
                        }
                        case ';': 
                        case '{': {
                            args = new ActualArgumentList(SassList.Separator.COMMA, Collections.emptyList());
                            break;
                        }
                        case '(': {
                            args = (ActualArgumentList)this.argValuelist(false);
                            ch = this.readNonWhitespace();
                            switch (ch) {
                                default: {
                                    this.reader.back(ch);
                                }
                                case ';': 
                                case '{': 
                            }
                        }
                    }
                    this.documentHandler.startInclude(this.uri, this.reader.getLine(), this.reader.getColumn(), name, args);
                    if (ch == '{') {
                        this.parse(false);
                    }
                    this.documentHandler.endInclude();
                    return;
                }
                case 3: {
                    this.wasOptional = false;
                    selectorList = this.parseSelectorList(true);
                    this.documentHandler.extendDirective(selectorList, this.wasOptional);
                    return;
                }
                case 4: {
                    this.parseFunctionMixin(true);
                    return;
                }
                case 5: {
                    evaluator = this.parseExpression(true);
                    this.consumeMarker('{');
                    this.documentHandler.startIfElseDirective();
                    this.documentHandler.ifDirective(evaluator);
                    this.parse(false);
                    while (true) {
                        try {
                            ch = this.readNonWhitespace();
                        }
                        catch (ParseException e) {
                            ch = ' ';
                        }
                        if (ch == 64) ** GOTO lbl171
                        this.reader.back(ch);
                        ** GOTO lbl192
lbl171:
                        // 1 sources

                        rule = '@' + this.parseName(false);
                        if (!"@else".equals(rule)) ** GOTO lbl184
                        ch = this.consumeMarkers('{', 'i');
                        if ('i' == ch) {
                            this.consumeMarker('f');
                            evaluator = this.parseExpression(true);
                            this.consumeMarker('{');
                            this.documentHandler.ifDirective(evaluator);
                            this.parse(false);
                            continue;
                        }
                        this.documentHandler.elseDirective();
                        this.parse(false);
                        ** GOTO lbl192
lbl184:
                        // 1 sources

                        if (!"@elseif".equals(rule)) break;
                        evaluator = this.parseExpression(true);
                        this.consumeMarker('{');
                        this.documentHandler.ifDirective(evaluator);
                        this.parse(false);
                    }
                    this.documentHandler.endIfElseDirective();
                    continue block59;
lbl192:
                    // 2 sources

                    this.documentHandler.endIfElseDirective();
                    return;
                }
                case 6: {
                    throw this.reader.createException("Unrecognized input: '" + rule + "'");
                }
                case 7: {
                    this.consumeMarker('{');
                    this.documentHandler.startFontFace();
                    this.parse(false);
                    this.documentHandler.endFontFace();
                    return;
                }
                case 8: {
                    this.parseFunctionMixin(false);
                    return;
                }
                case 9: {
                    this.documentHandler.returnDirective(this.parseExpressionOrList());
                    return;
                }
                case 10: {
                    this.documentHandler.contentDirective();
                    return;
                }
                case 11: {
                    this.parseEach();
                    return;
                }
                case 12: {
                    this.parseFor();
                    return;
                }
                case 13: {
                    this.parseWhile();
                    return;
                }
                case 14: {
                    this.media();
                    return;
                }
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    this.parseKeyframes(rule);
                    return;
                }
                case 20: {
                    this.documentHandler.debugDirective(this.parseExpressionOrList());
                    this.consumeMarker(';');
                    return;
                }
                case 21: {
                    this.documentHandler.warnDirective(this.parseExpressionOrList());
                    this.consumeMarker(';');
                    return;
                }
                case 22: {
                    this.documentHandler.errorDirective(this.parseExpressionOrList());
                    this.consumeMarker(';');
                    return;
                }
            }
            break;
        }
        if (block) {
            this.reader.back(rule);
            selectorList = this.parseSelectorList(false);
            this.consumeMarker('{');
            this.documentHandler.startSelector(this.source.getURI(), this.reader.getLine(), this.reader.getColumn(), selectorList);
            this.parse(false);
            this.documentHandler.endSelector();
        } else {
            this.parseUnrecognizedAtRule(rule);
        }
    }

    private void parseFunctionMixin(boolean mixin) {
        FormalArgumentList args;
        String name = this.parseName(true);
        char ch = this.readNonWhitespace();
        switch (ch) {
            case '{': {
                args = new FormalArgumentList(null, false);
                break;
            }
            case '(': {
                args = (FormalArgumentList)this.argValuelist(true);
                this.consumeMarker('{');
                break;
            }
            default: {
                throw this.reader.createException("Unrecognized input: '" + ch + "'");
            }
        }
        if (mixin) {
            this.documentHandler.startMixinDirective(name, args);
        } else {
            this.documentHandler.startFunctionDirective(name, args);
        }
        this.parse(false);
        if (mixin) {
            this.documentHandler.endMixinDirective();
        } else {
            this.documentHandler.endFunctionDirective();
        }
    }

    private void parseEach() {
        ArrayList<String> variables = new ArrayList<String>();
        StringBuilder builder = this.cachesBuilder;
        boolean wasName = false;
        block4: while (true) {
            char ch;
            if (ScssParser.isWhitespace(ch = this.reader.read())) {
                if (builder.length() == 0) continue;
                String in = ScssParser.trim(builder);
                if ("in".equals(in)) break;
                throw this.reader.createException("Unrecognized input: '" + in + "'");
            }
            switch (ch) {
                case '$': {
                    if (wasName || builder.length() > 0) {
                        throw this.reader.createException("Unrecognized input: '" + ch + "'");
                    }
                    variables.add(this.parseName(false));
                    wasName = true;
                    continue block4;
                }
                case ',': {
                    if (!wasName || builder.length() > 0) {
                        throw this.reader.createException("Unrecognized input: '" + ch + "'");
                    }
                    wasName = false;
                    continue block4;
                }
            }
            builder.append(ch);
        }
        SassListItem list = this.parseExpressionOrList();
        this.consumeMarker('{');
        this.documentHandler.startEachDirective(variables, list);
        this.parse(false);
        this.documentHandler.endEachDirective();
    }

    private void parseFor() {
        boolean exclusive;
        this.consumeMarker('$');
        String var = this.parseName(false);
        String key = this.parseName(true);
        if (!"from".equals(key)) {
            throw this.reader.createException("Unrecognized input: '" + key + "'");
        }
        SassListItem from = this.parseExpression(true);
        key = this.parseName(true);
        if ("through".equals(key)) {
            exclusive = false;
        } else if ("to".equals(key)) {
            exclusive = true;
        } else {
            throw this.reader.createException("Unrecognized input: '" + key + "'");
        }
        SassListItem to = this.parseExpression(true);
        this.consumeMarker('{');
        this.documentHandler.startForDirective(var, from, to, exclusive);
        this.parse(false);
        this.documentHandler.endForDirective();
    }

    private void parseWhile() {
        SassListItem condition = this.parseExpressionOrList();
        this.consumeMarker('{');
        this.documentHandler.startWhileDirective(condition);
        this.parse(false);
        this.documentHandler.endWhileDirective();
    }

    private void media() {
        MediaList media = this.mediaStatement();
        this.consumeMarker('{');
        this.documentHandler.startMedia(this.uri, this.reader.getLine(), this.reader.getColumn(), media);
        this.parse(false);
        this.documentHandler.endMedia();
    }

    private void parseKeyframes(String keyframeName) {
        StringInterpolationSequence animationName = this.parseStringInterpolationSequence(false);
        this.documentHandler.startKeyFrames(keyframeName, animationName);
        this.consumeMarker('{');
        StringBuilder builder = this.cachesBuilder;
        block4: while (true) {
            char ch = this.reader.read();
            switch (ch) {
                case '{': {
                    break;
                }
                case '}': {
                    break block4;
                }
                default: {
                    if (ScssParser.isWhitespace(ch) && builder.length() <= 0) continue block4;
                    builder.append(ch);
                    continue block4;
                }
            }
            String selector = ScssParser.trim(builder);
            this.documentHandler.startKeyframeSelector(selector);
            this.parse(false);
            this.documentHandler.endKeyframeSelector();
        }
        if (builder.length() > 0) {
            this.reader.back('}');
            this.reader.back(ScssParser.trim(builder));
            this.parse(false);
        }
        this.documentHandler.endKeyFrames();
    }

    private void parseUnrecognizedAtRule(String rule) {
        StringBuilder builder = this.cachesBuilder;
        builder.append(rule);
        int braceCount = 0;
        block6: while (true) {
            char ch;
            try {
                ch = this.reader.read();
            }
            catch (Exception e) {
                break;
            }
            switch (ch) {
                case '}': {
                    builder.append(ch);
                    if (--braceCount != 0) continue block6;
                    break block6;
                }
                case '{': {
                    ++braceCount;
                }
                default: {
                    builder.append(ch);
                    continue block6;
                }
            }
            break;
        }
        this.documentHandler.unrecognizedRule(ScssParser.trim(builder));
    }

    private SassListItem parseExpressionOrList() {
        SassListItem first = this.parseExpression(true);
        return this.parseExpressionOrList(first, false);
    }

    /*
     * Unable to fully structure code
     */
    private SassListItem parseExpressionOrList(SassListItem first, boolean hasParentWithComma) {
        next = null;
        list = first;
        sep = null;
        block5: while (true) {
            ch = this.reader.read();
            switch (ch) {
                case ',': {
                    list = this.concat(list, next);
                    if (sep == SassList.Separator.SPACE || hasParentWithComma) {
                        this.reader.back(ch);
                        if (next == null) {
                            return first;
                        }
                        next = new SassList(sep, (ArrayList)list);
                        return hasParentWithComma != false ? next : this.parseExpressionOrList(next, false);
                    }
                    if (sep == null) {
                        sep = SassList.Separator.COMMA;
                    } else if (next == null) {
                        throw this.reader.createException("Unrecognized input: '" + ch + "'");
                    }
                    next = this.parseExpression(false);
                    continue block5;
                }
                case ')': 
                case ';': 
                case '{': 
                case '}': {
                    this.reader.back(ch);
                    break block5;
                }
                default: {
                    this.reader.back(ch);
                }
                case ' ': {
                    if (sep == SassList.Separator.COMMA) {
                        this.reader.back(ch);
                        next = this.parseExpressionOrList(next, true);
                        continue block5;
                    }
                    sep = SassList.Separator.SPACE;
                    list = this.concat(list, next);
                    next = this.parseExpression(false);
                    if (next == null) ** break;
                    continue block5;
                    break block5;
                }
            }
            break;
        }
        if (next == null && list == first) {
            return first;
        }
        list = this.concat(list, next);
        return new SassList(sep, (ArrayList)list);
    }

    /*
     * Enabled aggressive block sorting
     */
    private SassListItem parseExpression(boolean first) {
        StringBuilder builder = this.cachesBuilder;
        Object left = null;
        boolean wasWhite = false;
        boolean wasOperation = false;
        block41: while (true) {
            char ch;
            if (ScssParser.isWhitespace(ch = this.reader.read())) {
                if ((left = this.concatIfnotEmpty(left, builder)) == null) continue;
                if (!wasOperation) {
                    wasWhite = true;
                }
                left = this.concat(left, LexicalUnitImpl.WHITESPACE);
                continue;
            }
            switch (ch) {
                case '.': {
                    if (!this.isNextDigit(false)) {
                        this.reader.back(ch);
                        break block41;
                    }
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    if (builder.length() != 0 || wasWhite) break;
                    wasOperation = false;
                    left = this.concat(left, this.parseNumber(ch));
                    continue block41;
                }
                case '+': {
                    left = this.concatIfnotEmpty(left, builder);
                }
                case '-': {
                    if (builder.length() != 0 || this.stringSequence != null) break;
                    if (left == null || wasWhite || wasOperation) {
                        if (this.isNextDigit(true)) {
                            if (wasWhite) break;
                            wasOperation = false;
                            left = this.concat(left, this.parseNumber(ch));
                            continue block41;
                        }
                        if (this.isNextIdentifierPart()) break;
                        wasWhite = false;
                        if (left == null || wasOperation) {
                            left = LexicalUnitImpl.createNumber(this.uri, this.reader.getLine(), this.reader.getColumn(), 0.0);
                        }
                    }
                    wasOperation = true;
                    left = this.concat(left, ch == '+' ? LexicalUnitImpl.createAdd(this.uri, this.reader.getLine(), this.reader.getColumn()) : LexicalUnitImpl.createMinus(this.uri, this.reader.getLine(), this.reader.getColumn()));
                    continue block41;
                }
                case '/': {
                    if (this.comment()) continue block41;
                    wasOperation = true;
                    wasWhite = false;
                    left = this.concat(this.concatIfnotEmpty(left, builder), LexicalUnitImpl.createSlash(this.uri, this.reader.getLine(), this.reader.getColumn()));
                    continue block41;
                }
                case '*': {
                    wasOperation = true;
                    wasWhite = false;
                    left = this.concat(this.concatIfnotEmpty(left, builder), LexicalUnitImpl.createMultiply(this.uri, this.reader.getLine(), this.reader.getColumn()));
                    continue block41;
                }
                case '%': {
                    wasOperation = true;
                    wasWhite = false;
                    left = this.concat(this.concatIfnotEmpty(left, builder), LexicalUnitImpl.createModulo(this.uri, this.reader.getLine(), this.reader.getColumn()));
                    continue block41;
                }
                case '>': {
                    SassListItem right;
                    wasOperation = true;
                    wasWhite = false;
                    char ch2 = this.reader.read();
                    if (ch2 == '=') {
                        right = LexicalUnitImpl.createGreaterThanOrEqualTo(this.uri, this.reader.getLine(), this.reader.getColumn());
                    } else {
                        this.reader.back(ch2);
                        right = LexicalUnitImpl.createGreaterThan(this.uri, this.reader.getLine(), this.reader.getColumn());
                    }
                    left = this.concat(this.concatIfnotEmpty(left, builder), right);
                    continue block41;
                }
                case '<': {
                    SassListItem right;
                    wasOperation = true;
                    wasWhite = false;
                    char ch2 = this.reader.read();
                    if ('=' == ch2) {
                        right = LexicalUnitImpl.createLessThanOrEqualTo(this.uri, this.reader.getLine(), this.reader.getColumn());
                    } else {
                        this.reader.back(ch2);
                        right = LexicalUnitImpl.createLessThan(this.uri, this.reader.getLine(), this.reader.getColumn());
                    }
                    left = this.concat(this.concatIfnotEmpty(left, builder), right);
                    continue block41;
                }
                case '=': {
                    char ch2 = this.reader.read();
                    if ('=' == ch2) {
                        wasOperation = true;
                        wasWhite = false;
                        left = this.concat(this.concatIfnotEmpty(left, builder), LexicalUnitImpl.createEquals(this.uri, this.reader.getLine(), this.reader.getColumn()));
                        continue block41;
                    }
                    this.reader.back(ch2);
                    break;
                }
                case '!': {
                    char ch2 = this.reader.read();
                    if ('=' == ch2) {
                        wasOperation = true;
                        wasWhite = false;
                        left = this.concat(this.concatIfnotEmpty(left, builder), LexicalUnitImpl.createNotEqual(this.uri, this.reader.getLine(), this.reader.getColumn()));
                        continue block41;
                    }
                    this.reader.back(ch2);
                    break;
                }
                case '&': {
                    left = this.concatIfnotEmpty(left, builder);
                    if (left == null) {
                        return LexicalUnitImpl.createParent(this.uri, this.reader.getLine(), this.reader.getColumn());
                    }
                    this.reader.back(' ');
                    break block41;
                }
                case '{': {
                    if (builder.length() > 0 && builder.charAt(builder.length() - 1) == '#') {
                        do {
                            builder.append(ch);
                        } while ((ch = this.reader.read()) != '}');
                        break;
                    }
                }
                case ')': 
                case ',': 
                case ';': 
                case '}': {
                    this.reader.back(ch);
                    break block41;
                }
                case ':': {
                    left = this.concatIfnotEmpty(left, builder);
                    SassListItem right = this.parseExpressionOrList(this.parseExpression(true), true);
                    return new SassList(SassList.Separator.COLON, this.toSassListItem(left, first), right);
                }
                case '\"': 
                case '\'': {
                    if (builder.length() > 0) {
                        throw this.reader.createException("Unrecognized input: '" + builder + ch + "'");
                    }
                    if (wasWhite) break;
                    wasOperation = false;
                    left = this.concat(left, LexicalUnitImpl.createString(this.uri, this.reader.getLine(), this.reader.getColumn(), this.parseQuotedStringInterpolationSequence(ch)));
                    continue block41;
                }
                case '(': {
                    String fname;
                    wasOperation = false;
                    if (wasWhite) break;
                    switch (fname = ScssParser.trim(builder)) {
                        case "url": {
                            left = this.concat(left, this.parseUrlFunction());
                            continue block41;
                        }
                        case "expression": {
                            left = LexicalUnitImpl.createIdent(this.uri, this.reader.getLine(), this.reader.getColumn(), fname + '(' + this.parseUnquotedString() + ')');
                            continue block41;
                        }
                        default: {
                            ActualArgumentList params = (ActualArgumentList)this.argValuelist(false);
                            left = this.concat(left, LexicalUnitImpl.createFunction(this.uri, this.reader.getLine(), this.reader.getColumn(), fname, params));
                            continue block41;
                        }
                        case "": 
                    }
                    SassListItem right = this.parseExpressionOrList();
                    if (right.getClass() == SassList.class && ((SassList)right).getSeparator() == SassList.Separator.COLON) {
                        right = new SassList(SassList.Separator.COMMA, right);
                    }
                    left = this.concat(left, right);
                    this.consumeMarker(')');
                    continue block41;
                }
                case '#': {
                    if (wasWhite || !this.parseInterpolation(builder)) break;
                    continue block41;
                }
                case 'a': 
                case 'n': 
                case 'o': {
                    String name;
                    if (builder.length() != 0) break;
                    builder.append(ch);
                    switch (name = this.parseName(false)) {
                        case "and": {
                            left = this.concat(left, LexicalUnitImpl.createAnd(this.uri, this.reader.getLine(), this.reader.getColumn()));
                            wasOperation = true;
                            wasWhite = false;
                            continue block41;
                        }
                        case "or": {
                            left = this.concat(left, LexicalUnitImpl.createOr(this.uri, this.reader.getLine(), this.reader.getColumn()));
                            wasOperation = true;
                            wasWhite = false;
                            continue block41;
                        }
                        case "not": {
                            left = this.concat(left, LexicalUnitImpl.createIdent(this.uri, this.reader.getLine(), this.reader.getColumn(), "false"));
                            left = this.concat(left, LexicalUnitImpl.createEquals(this.uri, this.reader.getLine(), this.reader.getColumn()));
                            wasOperation = true;
                            wasWhite = false;
                            continue block41;
                        }
                    }
                    if (wasWhite) {
                        this.reader.back(name);
                        this.reader.back(' ');
                        return this.toSassListItem(left, first);
                    }
                    builder.append(name);
                    continue block41;
                }
            }
            if (wasWhite) {
                this.reader.back(ch);
                this.reader.back(' ');
                return this.toSassListItem(left, first);
            }
            builder.append(ch);
            wasOperation = false;
        }
        left = this.concatIfnotEmpty(left, builder);
        return this.toSassListItem(left, first);
    }

    private Object concatIfnotEmpty(Object left, StringBuilder builder) {
        LexicalUnitImpl right;
        if (this.stringSequence != null) {
            LexicalUnitImpl right2 = LexicalUnitImpl.createIdent(this.uri, this.reader.getLine(), this.reader.getColumn(), this.createStringInterpolationSequence(builder));
            return this.concat(left, right2);
        }
        if (builder.length() == 0) {
            return left;
        }
        String trim = ScssParser.trim(builder);
        if (trim.isEmpty()) {
            return left;
        }
        if (trim.startsWith("$")) {
            right = LexicalUnitImpl.createVariable(this.uri, this.reader.getLine(), this.reader.getColumn() - trim.length(), trim.substring(1));
        } else {
            switch (trim) {
                case "!default": {
                    this.wasDefault = true;
                    return left;
                }
            }
            right = LexicalUnitImpl.createIdent(this.uri, this.reader.getLine(), this.reader.getColumn() - trim.length(), trim);
        }
        return this.concat(left, right);
    }

    private Object concat(Object left, SassListItem right) {
        ArrayList<SassListItem> list;
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        if (left.getClass() == ArrayList.class) {
            list = (ArrayList<SassListItem>)left;
        } else {
            list = new ArrayList<SassListItem>();
            list.add((SassListItem)left);
        }
        list.add(right);
        return list;
    }

    SassListItem toSassListItem(Object left, boolean first) {
        if (left == null) {
            if (this.wasDefault || !first) {
                return null;
            }
            char ch = this.reader.read();
            if (ch == ')') {
                this.reader.back(')');
                return first ? new SassList() : null;
            }
            throw this.reader.createException("Unrecognized input: '" + ch + "'");
        }
        if (left.getClass() == ArrayList.class) {
            return SassExpression.createExpression((ArrayList)left);
        }
        return (SassListItem)left;
    }

    private boolean isNextDigit(boolean orPoint) {
        char ch = this.reader.read();
        this.reader.back(ch);
        switch (ch) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return true;
            }
        }
        return orPoint ? ch == '.' : false;
    }

    private boolean isNextIdentifierPart() {
        char ch = this.reader.read();
        this.reader.back(ch);
        switch (ch) {
            case '#': 
            case '-': {
                return true;
            }
        }
        return Character.isLetter(ch);
    }

    private String parseQuotedString(char quote) {
        StringBuilder builder = this.cachesBuilder;
        boolean isSlash = false;
        char ch;
        while ((ch = this.reader.read()) != quote || isSlash) {
            builder.append(ch);
            isSlash = ch == '\\' && !isSlash;
        }
        return ScssParser.str(builder);
    }

    private StringInterpolationSequence parseQuotedStringInterpolationSequence(char quote) {
        StringBuilder builder = this.cachesBuilder;
        boolean isSlash = false;
        block4: while (true) {
            char ch = this.reader.read();
            switch (ch) {
                case '\\': {
                    isSlash = !isSlash;
                    break;
                }
                case '#': {
                    if (!this.parseInterpolation(builder)) break;
                    continue block4;
                }
                default: {
                    if (ch == quote && !isSlash) {
                        return this.createStringInterpolationSequence(builder);
                    }
                    isSlash = false;
                }
            }
            builder.append(ch);
        }
    }

    private SassListItem parseNumber(char ch) {
        String unit;
        StringBuilder builder = this.cachesBuilder;
        builder.append(ch);
        block45: while (true) {
            ch = this.reader.read();
            switch (ch) {
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    builder.append(ch);
                    continue block45;
                }
            }
            break;
        }
        double val = Double.parseDouble(ScssParser.trim(builder));
        while (true) {
            if (!Character.isLetter(ch) && ch != '%') break;
            builder.append(ch);
            ch = this.reader.read();
        }
        this.reader.back(ch);
        switch (unit = ScssParser.trim(builder)) {
            case "": {
                return LexicalUnitImpl.createNumber(this.uri, this.reader.getLine(), this.reader.getColumn(), val);
            }
            case "%": {
                return LexicalUnitImpl.createPercentage(this.uri, this.reader.getLine(), this.reader.getColumn(), val);
            }
            case "pt": {
                return LexicalUnitImpl.createPT(this.uri, this.reader.getLine(), this.reader.getColumn(), val);
            }
            case "mm": {
                return LexicalUnitImpl.createMM(this.uri, this.reader.getLine(), this.reader.getColumn(), val);
            }
            case "cm": {
                return LexicalUnitImpl.createCM(this.uri, this.reader.getLine(), this.reader.getColumn(), val);
            }
            case "pc": {
                return LexicalUnitImpl.createPC(this.uri, this.reader.getLine(), this.reader.getColumn(), val);
            }
            case "in": {
                return LexicalUnitImpl.createIN(this.uri, this.reader.getLine(), this.reader.getColumn(), val);
            }
            case "px": {
                return LexicalUnitImpl.createPX(this.uri, this.reader.getLine(), this.reader.getColumn(), val);
            }
            case "em": {
                return LexicalUnitImpl.createEMS(this.uri, this.reader.getLine(), this.reader.getColumn(), val);
            }
            case "lem": {
                return LexicalUnitImpl.createLEM(this.uri, this.reader.getLine(), this.reader.getColumn(), val);
            }
            case "rem": {
                return LexicalUnitImpl.createREM(this.uri, this.reader.getLine(), this.reader.getColumn(), val);
            }
            case "exs": {
                return LexicalUnitImpl.createEXS(this.uri, this.reader.getLine(), this.reader.getColumn(), val);
            }
            case "deg": {
                return LexicalUnitImpl.createDEG(this.uri, this.reader.getLine(), this.reader.getColumn(), val);
            }
            case "rad": {
                return LexicalUnitImpl.createRAD(this.uri, this.reader.getLine(), this.reader.getColumn(), val);
            }
            case "grad": {
                return LexicalUnitImpl.createGRAD(this.uri, this.reader.getLine(), this.reader.getColumn(), val);
            }
            case "ms": {
                return LexicalUnitImpl.createMS(this.uri, this.reader.getLine(), this.reader.getColumn(), val);
            }
            case "s": {
                return LexicalUnitImpl.createS(this.uri, this.reader.getLine(), this.reader.getColumn(), val);
            }
            case "Hz": {
                return LexicalUnitImpl.createHZ(this.uri, this.reader.getLine(), this.reader.getColumn(), val);
            }
            case "kHz": {
                return LexicalUnitImpl.createKHZ(this.uri, this.reader.getLine(), this.reader.getColumn(), val);
            }
        }
        return LexicalUnitImpl.createDimen(this.uri, this.reader.getLine(), this.reader.getColumn(), val, unit);
    }

    private String parseName(boolean skipWhitespaces) {
        StringBuilder builder;
        block5: {
            char ch;
            builder = this.cachesBuilder;
            block3: while (true) {
                if (ScssParser.isWhitespace(ch = this.reader.read())) {
                    if (skipWhitespaces && builder.length() == 0) continue;
                    this.reader.back(ch);
                    break block5;
                }
                switch (ch) {
                    case '-': 
                    case '_': {
                        builder.append(ch);
                        continue block3;
                    }
                }
                if (!Character.isLetterOrDigit(ch)) break;
                builder.append(ch);
            }
            this.reader.back(ch);
        }
        return ScssParser.trim(builder);
    }

    private String parseUnquotedString() {
        StringBuilder builder = this.cachesBuilder;
        char ch;
        while ((ch = this.reader.read()) != ')') {
            builder.append(ch);
        }
        return ScssParser.trim(builder);
    }

    private LexicalUnitImpl parseUrlFunction() {
        char ch = this.readNonWhitespace();
        block0 : switch (ch) {
            case '\"': 
            case '\'': {
                char ch2 = this.reader.read();
                this.reader.back(ch2);
                switch (ch2) {
                    case '#': 
                    case '$': {
                        break;
                    }
                    default: {
                        break block0;
                    }
                }
            }
            case '$': {
                this.reader.back(ch);
                ActualArgumentList params = (ActualArgumentList)this.argValuelist(false);
                return LexicalUnitImpl.createFunction(this.uri, this.reader.getLine(), this.reader.getColumn(), "url", params);
            }
        }
        this.reader.back(ch);
        StringInterpolationSequence url = this.parseStringInterpolationSequence(true);
        this.consumeMarker(')');
        return LexicalUnitImpl.createURL(this.uri, this.reader.getLine(), this.reader.getColumn(), url);
    }

    /*
     * Enabled aggressive block sorting
     */
    private StringInterpolationSequence parseStringInterpolationSequence(boolean untilClosingParenthesis) {
        StringBuilder builder = this.cachesBuilder;
        block6: while (true) {
            char ch = this.reader.read();
            if (!untilClosingParenthesis && ScssParser.isWhitespace(ch)) {
                if (builder.length() == 0) continue;
                this.reader.back(ch);
                return this.createStringInterpolationSequence(builder);
            }
            switch (ch) {
                case '#': {
                    if (!this.parseInterpolation(builder)) break;
                    continue block6;
                }
                case '\"': 
                case '\'': {
                    String str;
                    int idx1;
                    String trim;
                    List<SassListItem> sequence = this.stringSequence;
                    if (sequence == null) {
                        sequence = this.stringSequence = new ArrayList<SassListItem>();
                    }
                    if (builder.length() > 0 && !(trim = ScssParser.trim(builder)).isEmpty()) {
                        sequence.add(new StringItem(trim));
                    }
                    if ((idx1 = (str = this.parseQuotedString(ch)).indexOf("#{")) >= 0) {
                        int idx2;
                        sequence.add(new StringItem(ch + str.substring(0, idx1)));
                        while (true) {
                            idx2 = str.indexOf(125, ++idx1 + 1) + 1;
                            this.reader.back(str.substring(idx1, idx2));
                            this.parseInterpolation(builder);
                            idx1 = str.indexOf("#{", idx2);
                            if (idx1 <= 0) break;
                            sequence.add(new StringItem(str.substring(idx2, idx1)));
                        }
                        sequence.add(new StringItem(str.substring(idx2) + ch));
                        continue block6;
                    }
                    sequence.add(LexicalUnitImpl.createString(this.uri, this.reader.getLine(), this.reader.getColumn(), str));
                    continue block6;
                }
                case '(': 
                case ',': 
                case '.': 
                case ':': 
                case '=': 
                case ']': 
                case '{': 
                case '}': {
                    if (untilClosingParenthesis) break;
                }
                case ')': {
                    this.reader.back(ch);
                    return this.createStringInterpolationSequence(builder);
                }
            }
            builder.append(ch);
        }
    }

    private StringInterpolationSequence createStringInterpolationSequence(String str) {
        List<SassListItem> sequence = this.stringSequence;
        if (sequence != null) {
            this.stringSequence = null;
            if (!str.isEmpty()) {
                sequence.add(new StringItem(str));
            }
            return new StringInterpolationSequence(sequence);
        }
        return new StringInterpolationSequence(str);
    }

    private StringInterpolationSequence createStringInterpolationSequence(StringBuilder builder) {
        return this.createStringInterpolationSequence(ScssParser.str(builder));
    }

    private boolean parseInterpolation(StringBuilder builder) {
        char ch = this.reader.read();
        if (ch != '{') {
            this.reader.back(ch);
            return false;
        }
        List<SassListItem> sequence = this.stringSequence;
        if (sequence == null) {
            sequence = new ArrayList<SassListItem>();
        }
        this.stringSequence = null;
        if (builder.length() > 0) {
            sequence.add(new StringItem(ScssParser.str(builder)));
        }
        int line = this.reader.getLine();
        int column = this.reader.getColumn();
        SassListItem item = this.parseExpressionOrList();
        sequence.add(new Interpolation(item, line, column));
        this.consumeMarker('}');
        this.stringSequence = sequence;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private <T> T argValuelist(boolean formal) {
        Object object;
        boolean hasVariableArguments;
        ArrayList<Variable> args = new ArrayList<Variable>();
        int varArgumentPos = -1;
        String name = null;
        SassListItem exp = null;
        boolean wasSpace = false;
        block7: while (true) {
            block19: {
                char ch;
                if (ScssParser.isWhitespace(ch = this.reader.read())) {
                    wasSpace = true;
                    continue;
                }
                switch (ch) {
                    case '$': {
                        if (name != null) break;
                        name = this.parseName(false);
                        wasSpace = false;
                        continue block7;
                    }
                    case ')': {
                        if (name == null) break block7;
                        if (!formal) {
                            exp = LexicalUnitImpl.createVariable(this.uri, this.reader.getLine(), this.reader.getColumn(), name);
                            name = null;
                        }
                        args.add(new Variable(name, exp));
                        break block7;
                    }
                    case ',': {
                        if (name == null) continue block7;
                        if (!formal) {
                            exp = LexicalUnitImpl.createVariable(this.uri, this.reader.getLine(), this.reader.getColumn(), name);
                            name = null;
                        }
                        break block19;
                    }
                    case ':': {
                        exp = this.parseExpressionOrList(this.parseExpression(true), true);
                        break block19;
                    }
                    case '.': {
                        if (varArgumentPos >= 0) break;
                        char ch2 = this.reader.read();
                        if ('.' == ch2) {
                            char ch3 = this.reader.read();
                            if ('.' == ch3) {
                                varArgumentPos = args.size();
                                continue block7;
                            }
                            this.reader.back(ch3);
                            break;
                        }
                        this.reader.back(ch2);
                    }
                }
                this.reader.back(ch);
                if (name != null) {
                    if (wasSpace) {
                        this.reader.back(' ');
                    }
                    this.reader.back(name);
                    this.reader.back('$');
                    name = null;
                }
                exp = this.parseExpressionOrList(this.parseExpression(true), true);
            }
            args.add(new Variable(name, exp));
            name = null;
            wasSpace = false;
        }
        if (varArgumentPos < 0) {
            hasVariableArguments = false;
        } else {
            hasVariableArguments = true;
            if (varArgumentPos != args.size() - 1) {
                this.reader.createException("Varargs must on last parameter");
            }
        }
        if (formal) {
            object = new FormalArgumentList(args, hasVariableArguments);
            return (T)object;
        }
        object = new ActualArgumentList(SassList.Separator.COMMA, args, hasVariableArguments);
        return (T)object;
    }

    private boolean comment() {
        char ch = this.reader.read();
        switch (ch) {
            case '*': {
                StringBuilder builder = new StringBuilder();
                builder.append("/*");
                boolean wasAsterix = false;
                while (true) {
                    ch = this.reader.read();
                    builder.append(ch);
                    if (ch == '/' && wasAsterix) {
                        String comment = ScssParser.trim(builder);
                        if (comment.startsWith("/**")) {
                            this.documentHandler.comment(comment);
                        }
                        return true;
                    }
                    wasAsterix = ch == '*';
                }
            }
        }
        this.reader.back(ch);
        return false;
    }

    private static String trim(StringBuilder builder) {
        return ScssParser.str(builder).trim();
    }

    private static String str(StringBuilder builder) {
        String str = builder.toString();
        builder.setLength(0);
        return str;
    }

    private void consumeMarker(char marker) {
        char ch = this.readNonWhitespace();
        if (ch == marker) {
            return;
        }
        throw this.reader.createException("Unrecognized input: '" + ch + "' expected: '" + marker + "'");
    }

    private char consumeMarkers(char marker1, char marker2) {
        char ch = this.readNonWhitespace();
        if (ch == marker1 || ch == marker2) {
            return ch;
        }
        throw this.reader.createException("Unrecognized input: '" + ch + "' expected: '" + marker1 + "' or '" + marker2 + "'");
    }

    private char readNonWhitespace() {
        char ch;
        while (ScssParser.isWhitespace(ch = this.reader.read()) || ch == '/' && this.comment()) {
        }
        return ch;
    }

    private static boolean isWhitespace(char ch) {
        if (ch <= ' ') {
            return true;
        }
        switch (ch) {
            case '\u00a0': {
                return true;
            }
        }
        return false;
    }
}

