/*
 * Decompiled with CFR 0.152.
 */
package com.inet.sass.parser;

import com.inet.sass.parser.ParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public class ScssLookAheadReader {
    private final Reader reader;
    private String uri;
    private final StringBuilder cache = new StringBuilder();
    private StringReader cache2;
    private int cachePos;
    private int column;
    private int line;

    ScssLookAheadReader(Reader reader, String uri) {
        this.uri = uri;
        this.reader = reader.markSupported() ? reader : new BufferedReader(reader);
    }

    private int readCharBlockMarker() throws IOException {
        if (this.cache2 != null) {
            int ch = this.cache2.read();
            if (ch != -1) {
                return ch;
            }
            this.cache2 = null;
        }
        return this.reader.read();
    }

    int nextBlockMarker() {
        try {
            if (this.cachePos < this.cache.length()) {
                if (this.cache2 != null) {
                    int ch;
                    while ((ch = this.cache2.read()) >= 0) {
                        this.cache.setCharAt(this.cachePos, (char)ch);
                    }
                }
                String str = this.cache.substring(this.cachePos);
                this.cache2 = new StringReader(str);
            }
            this.cachePos = 0;
            this.cache.setLength(0);
            int parenthesis = 0;
            boolean isSlash = false;
            while (true) {
                int i;
                int ch;
                if ((ch = this.readCharBlockMarker()) < 0) {
                    for (i = 0; i < this.cache.length(); ++i) {
                        if (Character.isWhitespace(this.cache.charAt(i))) continue;
                        return 59;
                    }
                    return -1;
                }
                this.cache.append((char)ch);
                block1 : switch (ch) {
                    case 47: {
                        if (!isSlash || parenthesis > 0 && this.cache.indexOf("url") > 0) break;
                        this.cache.setLength(this.cache.length() - 2);
                        while ((ch = this.readCharBlockMarker()) != 10 && ch != -1) {
                        }
                        this.cache.append('\n');
                        break;
                    }
                    case 42: {
                        if (!isSlash) break;
                        boolean isAsterix = false;
                        while (true) {
                            ch = this.reader.read();
                            switch (ch) {
                                case -1: {
                                    throw this.createException("Unexpected end of Scss data");
                                }
                            }
                            this.cache.append((char)ch);
                            if (ch == 47 && isAsterix) {
                                ch = 0;
                                break block1;
                            }
                            isAsterix = ch == 42;
                        }
                    }
                    case 123: {
                        if (this.cache.charAt(this.cache.length() - 2) == '#') {
                            do {
                                ch = this.readCharBlockMarker();
                                switch (ch) {
                                    case -1: {
                                        throw this.createException("Unexpected end of Scss data");
                                    }
                                }
                                this.cache.append((char)ch);
                            } while (ch != 125);
                            ch = 0;
                            break;
                        }
                        for (i = this.cache.length() - 2; i > 0; --i) {
                            ch = this.cache.charAt(i);
                            if (ch <= 32) continue;
                            if (ch != 58) break;
                            return 58;
                        }
                        return 123;
                    }
                    case 59: 
                    case 125: {
                        if (parenthesis != 0) break;
                        return ch;
                    }
                    case 40: {
                        ++parenthesis;
                        break;
                    }
                    case 41: {
                        if (--parenthesis >= 0) break;
                        throw this.createException("Unrecognized input: '" + this.cache.toString().trim() + "'");
                    }
                    case 34: 
                    case 39: {
                        isSlash = false;
                        while (true) {
                            int ch2 = this.readCharBlockMarker();
                            switch (ch2) {
                                case -1: 
                                case 10: 
                                case 13: {
                                    throw this.createException("Missing string quote: " + (char)ch);
                                }
                            }
                            this.cache.append((char)ch2);
                            if (ch == ch2 && !isSlash) break block1;
                            isSlash = ch2 == 92 && !isSlash;
                        }
                    }
                }
                isSlash = ch == 47;
            }
        }
        catch (IOException ex) {
            throw this.createException(ex);
        }
    }

    String getLookAhead() {
        return this.cache.toString();
    }

    char read() {
        try {
            if (this.cachePos < this.cache.length()) {
                return this.incLineColumn(this.cache.charAt(this.cachePos++));
            }
            int ch = this.reader.read();
            if (ch == -1) {
                throw this.createException("Unexpected end of Scss data");
            }
            if (ch == 47) {
                int ch2 = this.reader.read();
                switch (ch2) {
                    case -1: {
                        break;
                    }
                    case 47: {
                        while ((ch = this.reader.read()) != 10 && ch != -1) {
                        }
                        ch = 10;
                        break;
                    }
                    default: {
                        this.back((char)ch2);
                    }
                }
            }
            return this.incLineColumn(ch);
        }
        catch (IOException ex) {
            throw this.createException(ex);
        }
    }

    void back(char ch) {
        if (this.cachePos > 0) {
            --this.cachePos;
            this.cache.setCharAt(this.cachePos, ch);
        } else {
            this.cache.insert(0, ch);
        }
        --this.column;
    }

    void back(CharSequence str) {
        int length = str.length();
        for (int i = length - 1; i >= 0; --i) {
            this.back(str.charAt(i));
        }
    }

    private char incLineColumn(int ch) {
        if (ch == 10) {
            ++this.line;
            this.column = 0;
        } else {
            ++this.column;
        }
        return (char)ch;
    }

    int getLine() {
        return this.line + 1;
    }

    int getColumn() {
        return this.column + 1;
    }

    ParseException createException(Throwable th) {
        ParseException pex = new ParseException(th.toString(), this.uri, this.getLine(), this.getColumn());
        pex.initCause(th);
        return pex;
    }

    ParseException createException(String msg) {
        return new ParseException(msg, this.uri, this.getLine(), this.getColumn());
    }
}

