/*
 * Decompiled with CFR 0.152.
 */
package com.inet.sass.parser;

import com.inet.sass.ScssContext;
import com.inet.sass.parser.LexicalUnitImpl;
import com.inet.sass.parser.ParseException;
import com.inet.sass.parser.SassListItem;
import com.inet.sass.tree.Node;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class SassList
implements SassListItem,
Iterable<SassListItem> {
    private int line = -1;
    private int column = -1;
    private Separator separator;
    private final List<SassListItem> items;

    public SassList() {
        this(Separator.SPACE, new SassListItem[0]);
    }

    public SassList(SassListItem ... items) {
        this(Separator.SPACE, items);
    }

    public SassList(Separator sep, SassListItem ... items) {
        this.separator = sep;
        this.items = Arrays.asList(items);
    }

    public SassList(Separator sep, List<SassListItem> items) {
        this.separator = sep;
        this.items = items;
    }

    @Override
    public short getItemType() {
        return 115;
    }

    @Override
    public int getLineNumber() {
        return this.line < 0 && this.items.size() > 0 ? this.items.get(0).getLineNumber() : this.line;
    }

    @Override
    public int getColumnNumber() {
        return this.column < 0 && this.items.size() > 0 ? this.items.get(0).getColumnNumber() : this.column;
    }

    public void setSourcePosition(int line, int column) {
        this.line = line;
        this.column = column;
    }

    public Separator getSeparator() {
        return this.separator;
    }

    @Override
    public LexicalUnitImpl getContainedValue() {
        if (this.size() != 1 || !(this.get(0) instanceof LexicalUnitImpl)) {
            throw new ParseException("Expected a one-element list, actual value: " + this.getStringWithNesting());
        }
        return (LexicalUnitImpl)this.get(0);
    }

    @Override
    public String unquotedString() {
        if (this.size() != 1) {
            return this.printState();
        }
        if (this.get(0) instanceof SassList) {
            return ((SassList)this.get(0)).unquotedString();
        }
        String result = this.printState();
        if (result.length() >= 2 && (result.charAt(0) == '\"' && result.charAt(result.length() - 1) == '\"' || result.charAt(0) == '\'' && result.charAt(result.length() - 1) == '\'')) {
            result = result.substring(1, result.length() - 1);
        }
        return result;
    }

    @Override
    public boolean containsArithmeticalOperator() {
        for (SassListItem item : this) {
            if (!item.containsArithmeticalOperator()) continue;
            return true;
        }
        return false;
    }

    @Override
    public SassList evaluateFunctionsAndExpressions(ScssContext context, boolean evaluateArithmetics) {
        ArrayList<SassListItem> list = new ArrayList<SassListItem>();
        for (SassListItem item : this) {
            list.add(item.evaluateFunctionsAndExpressions(context, evaluateArithmetics));
        }
        return new SassList(this.getSeparator(), list);
    }

    static List<SassListItem> replaceVariables(ScssContext context, List<SassListItem> items) {
        int size = items.size();
        ArrayList<SassListItem> list = new ArrayList<SassListItem>(size);
        for (int i = 0; i < size; ++i) {
            list.add(items.get(i).evaluateFunctionsAndExpressions(context, true));
        }
        return list;
    }

    @Override
    public String buildString(Node.BuildStringStrategy strategy) {
        StringBuilder result = new StringBuilder();
        List<SassListItem> items = this.items;
        int size = items.size();
        boolean first = true;
        boolean isMap = false;
        for (int i = 0; i < size; ++i) {
            SassListItem itemValue = items.get(i);
            String item = itemValue.buildString(strategy);
            if (item.isEmpty()) continue;
            if (first) {
                isMap = itemValue.getClass() == SassList.class && ((SassList)itemValue).separator == Separator.COLON;
                if (isMap) {
                    result.append('(');
                }
            } else {
                result.append((Object)this.separator);
            }
            result.append(item);
            first = false;
        }
        if (isMap) {
            result.append(')');
        }
        return result.toString();
    }

    @Override
    public String printState() {
        return this.buildString(Node.PRINT_STRATEGY);
    }

    public String toString() {
        return "SassList [" + this.getStringWithNesting() + "]";
    }

    public String getStringWithNesting() {
        String result = "(";
        for (int i = 0; i < this.size(); ++i) {
            SassListItem item = this.get(i);
            result = item instanceof SassList ? result + ((SassList)item).getStringWithNesting() : result + item.printState();
            if (i >= this.size() - 1) continue;
            result = result + (Object)((Object)this.separator);
        }
        result = result + ")";
        return result;
    }

    @Override
    public SassList updateUrl(String prefix) {
        if (this.size() > 0) {
            SassList result = new SassList(this.getSeparator(), SassList.updateUrl(this.items, prefix));
            return result;
        }
        return this;
    }

    static List<SassListItem> updateUrl(List<SassListItem> items, String prefix) {
        int size = items.size();
        ArrayList<SassListItem> newItems = new ArrayList<SassListItem>(size);
        for (int i = 0; i < size; ++i) {
            newItems.add(items.get(i).updateUrl(prefix));
        }
        return newItems;
    }

    public boolean equals(Object o) {
        if (!(o instanceof SassList)) {
            return false;
        }
        SassList other = (SassList)o;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.size() > 1 && !this.getSeparator().equals((Object)other.getSeparator())) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).equals(other.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 1;
        for (int i = 0; i < this.size(); ++i) {
            int currentHash = 0;
            if (this.get(i) != null) {
                currentHash = this.get(i).hashCode();
            }
            result = 41 * result + currentHash;
        }
        return result;
    }

    public int size() {
        return this.items.size();
    }

    public SassListItem get(int index) {
        return this.items.get(index);
    }

    @Override
    public Iterator<SassListItem> iterator() {
        return this.items.iterator();
    }

    protected List<SassListItem> getItems() {
        return this.items;
    }

    public static enum Separator {
        COMMA(", "),
        SPACE(" "),
        COLON(":");

        private String separator;

        private Separator(String sep) {
            this.separator = sep;
        }

        public String toString() {
            return this.separator;
        }
    }
}

