/*
 * Decompiled with CFR 0.152.
 */
package com.inet.sass.parser;

import com.inet.sass.ScssContext;
import com.inet.sass.expression.ArithmeticExpressionEvaluator;
import com.inet.sass.expression.BinaryOperator;
import com.inet.sass.parser.LexicalUnitImpl;
import com.inet.sass.parser.ParseException;
import com.inet.sass.parser.SassListItem;
import com.inet.sass.tree.Node;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SassExpression
implements SassListItem {
    private List<SassListItem> items;
    private int line = 0;
    private int column = 0;

    private SassExpression(List<SassListItem> items) {
        if (!items.isEmpty()) {
            this.line = items.get(0).getLineNumber();
            this.column = items.get(0).getColumnNumber();
        }
        this.items = items;
    }

    @Override
    public short getItemType() {
        return 114;
    }

    public static SassListItem createExpression(SassListItem ... items) {
        return SassExpression.createExpression(Arrays.asList(items));
    }

    public static SassListItem createExpression(List<SassListItem> items) {
        int lastNonWhitespace;
        for (lastNonWhitespace = items.size() - 1; lastNonWhitespace > 0 && items.get(lastNonWhitespace) == LexicalUnitImpl.WHITESPACE; --lastNonWhitespace) {
        }
        if (lastNonWhitespace < items.size() - 1) {
            items = new ArrayList<SassListItem>(items.subList(0, lastNonWhitespace + 1));
        }
        if (items.size() == 1) {
            return items.get(0);
        }
        return new SassExpression(items);
    }

    @Override
    public int getLineNumber() {
        return this.line;
    }

    @Override
    public int getColumnNumber() {
        return this.column;
    }

    @Override
    public boolean containsArithmeticalOperator() {
        for (SassListItem item : this.items) {
            if (!item.containsArithmeticalOperator()) continue;
            return true;
        }
        int previousIndex = SassExpression.getNextNonspaceIndex(this.items, 0);
        int currentIndex = SassExpression.getNextNonspaceIndex(this.items, previousIndex + 1);
        int nextIndex = SassExpression.getNextNonspaceIndex(this.items, currentIndex + 1);
        if (nextIndex >= this.items.size()) {
            return false;
        }
        while (nextIndex < this.items.size()) {
            SassListItem previous = this.items.get(previousIndex);
            SassListItem current = this.items.get(currentIndex);
            SassListItem next = this.items.get(nextIndex);
            previousIndex = currentIndex;
            currentIndex = nextIndex;
            nextIndex = SassExpression.getNextNonspaceIndex(this.items, nextIndex + 1);
            short currentType = current.getItemType();
            if (!(currentType == BinaryOperator.DIV.type ? (this.isVariable(previous) || this.isVariable(next)) && !this.containsInterpolation(previous) && !this.containsInterpolation(next) : this.isOperator(currentType) && !this.containsInterpolation(previous) && !this.containsInterpolation(next))) continue;
            return true;
        }
        return false;
    }

    private boolean isOperator(short type) {
        for (BinaryOperator operator : BinaryOperator.values()) {
            if (type != operator.type) continue;
            return true;
        }
        return false;
    }

    private boolean isVariable(SassListItem item) {
        return item.getItemType() == 100;
    }

    private boolean containsInterpolation(SassListItem item) {
        if (item.getClass() == LexicalUnitImpl.class) {
            return ((LexicalUnitImpl)item).containsInterpolation();
        }
        return false;
    }

    public static int getNextNonspaceIndex(List<SassListItem> list, int startIndex) {
        for (int i = startIndex; i < list.size(); ++i) {
            if (list.get(i) == LexicalUnitImpl.WHITESPACE) continue;
            return i;
        }
        return list.size();
    }

    @Override
    public SassListItem evaluateFunctionsAndExpressions(ScssContext context, boolean evaluateArithmetics) {
        if (evaluateArithmetics && !this.items.isEmpty()) {
            return ArithmeticExpressionEvaluator.evaluate(context, this.items);
        }
        ArrayList<SassListItem> list = new ArrayList<SassListItem>();
        for (SassListItem item : this.items) {
            list.add(item.evaluateFunctionsAndExpressions(context, evaluateArithmetics));
        }
        return new SassExpression(list);
    }

    @Override
    public SassExpression updateUrl(String prefix) {
        ArrayList<SassListItem> newItems = new ArrayList<SassListItem>(this.items.size());
        for (SassListItem item : this.items) {
            newItems.add(item.updateUrl(prefix));
        }
        return new SassExpression(newItems);
    }

    @Override
    public String printState() {
        return this.buildString(Node.PRINT_STRATEGY);
    }

    @Override
    public String buildString(Node.BuildStringStrategy strategy) {
        StringBuilder result = new StringBuilder();
        for (SassListItem item : this.items) {
            result.append(strategy.build(item));
        }
        return result.toString();
    }

    public String toString() {
        String result = "SassExpression[";
        result = result + this.buildString(Node.TO_STRING_STRATEGY);
        return result + "]";
    }

    @Override
    public String unquotedString() {
        if (this.items.size() == 1 && this.items.get(0) instanceof LexicalUnitImpl) {
            return ((LexicalUnitImpl)this.items.get(0)).unquotedString();
        }
        return this.printState();
    }

    @Override
    public LexicalUnitImpl getContainedValue() {
        if (this.items.size() != 1 || !(this.items.get(0) instanceof LexicalUnitImpl)) {
            throw new ParseException("getContainedValue() can only be used for an expression that contains one simple value. Actual value: " + this.toString());
        }
        return (LexicalUnitImpl)this.items.get(0);
    }

    public boolean equals(Object o) {
        if (!(o instanceof SassExpression)) {
            return false;
        }
        SassExpression other = (SassExpression)o;
        if (this.items.size() != other.items.size()) {
            return false;
        }
        for (int i = 0; i < this.items.size(); ++i) {
            if (this.items.get(i).equals(other.items.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 1;
        for (int i = 0; i < this.items.size(); ++i) {
            int currentHash = 0;
            if (this.items.get(i) != null) {
                currentHash = this.items.get(i).hashCode();
            }
            result = 41 * result + currentHash;
        }
        return result;
    }
}

