/*
 * Decompiled with CFR 0.152.
 */
package com.inet.sass.parser;

import com.inet.sass.parser.ActualArgumentList;
import com.inet.sass.tree.Node;
import com.inet.sass.tree.SourceLocation;

public class ParseException
extends RuntimeException {
    private SourceLocation currentUnit;

    public ParseException(String message) {
        super(message);
    }

    public ParseException(String message, SourceLocation unit) {
        this(message);
        this.currentUnit = unit;
    }

    public ParseException(String message, ActualArgumentList args) {
        this(message);
        if (args.size() > 0) {
            this.currentUnit = args.get(0);
        }
    }

    public ParseException(String message, String uri, int line, int column) {
        super(message + " in line " + line + ", column " + column + ParseException.getLocation(uri));
    }

    @Override
    public String getMessage() {
        String message = super.getMessage();
        if (this.currentUnit != null) {
            message = message + " at line " + this.currentUnit.getLineNumber() + ", column " + this.currentUnit.getColumnNumber() + this.getLocation();
        }
        return message;
    }

    private String getLocation() {
        if (this.currentUnit == null) {
            return "";
        }
        String fileName = this.currentUnit.getUri();
        if (fileName == null && this.currentUnit instanceof Node) {
            for (Node node = (Node)this.currentUnit; fileName == null && node != null; node = node.getParentNode()) {
                fileName = node.getUri();
            }
        }
        return ParseException.getLocation(fileName);
    }

    private static String getLocation(String fileName) {
        if (fileName != null) {
            fileName = fileName.substring(fileName.lastIndexOf(47) + 1);
            return ", in file " + fileName;
        }
        return "";
    }
}

