/*
 * Decompiled with CFR 0.152.
 */
package com.inet.sass.parser;

import com.inet.sass.ScssContext;
import com.inet.sass.function.SCSSFunctionGenerator;
import com.inet.sass.handler.SCSSErrorHandler;
import com.inet.sass.parser.ActualArgumentList;
import com.inet.sass.parser.ParseException;
import com.inet.sass.parser.SCSSLexicalUnit;
import com.inet.sass.parser.SassListItem;
import com.inet.sass.parser.StringInterpolationSequence;
import com.inet.sass.parser.StringItem;
import com.inet.sass.parser.Variable;
import com.inet.sass.tree.BlockNode;
import com.inet.sass.tree.FunctionCall;
import com.inet.sass.tree.FunctionDefNode;
import com.inet.sass.tree.Node;
import com.inet.sass.util.ColorUtil;
import com.inet.sass.util.StringUtil;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Locale;

public class LexicalUnitImpl
implements SCSSLexicalUnit,
SassListItem {
    public static final long PRECISION = 100000L;
    private static final ThreadLocal<DecimalFormat> CSS_FLOAT_FORMAT = new ThreadLocal<DecimalFormat>(){

        @Override
        protected DecimalFormat initialValue() {
            return new DecimalFormat("0.#####", DecimalFormatSymbols.getInstance(Locale.US));
        }
    };
    public static final LexicalUnitImpl WHITESPACE = new LexicalUnitImpl(null, 0, 0, 35, " ");
    private short type;
    private int line;
    private int column;
    private double f;
    private String sdimension;
    private StringInterpolationSequence s;
    private String fname;
    private ActualArgumentList params;
    private String uri;
    private String printState;
    private boolean varNotResolved;

    LexicalUnitImpl(String uri, int line, int column, short type) {
        this.uri = uri;
        this.line = line;
        this.column = column;
        this.type = type;
    }

    LexicalUnitImpl(String uri, int line, int column, short type, double f) {
        this(uri, line, column, type);
        this.f = f;
    }

    LexicalUnitImpl(String uri, int line, int column, short type, String sdimension, double f) {
        this(uri, line, column, type, f);
        this.sdimension = sdimension;
    }

    LexicalUnitImpl(String uri, int line, int column, short type, String s) {
        this(uri, line, column, type, new StringInterpolationSequence(s));
    }

    LexicalUnitImpl(String uri, int line, int column, short type, StringInterpolationSequence s) {
        this(uri, line, column, type);
        this.s = s;
    }

    LexicalUnitImpl(String uri, short type, int line, int column, String fname, ActualArgumentList params) {
        this(uri, line, column, type);
        this.fname = fname;
        this.params = params;
        this.uri = uri;
    }

    @Override
    public int getLineNumber() {
        return this.line;
    }

    @Override
    public int getColumnNumber() {
        return this.column;
    }

    @Override
    public short getItemType() {
        return this.type;
    }

    private void setLexicalUnitType(short type) {
        this.type = type;
    }

    public boolean isUnitlessNumber() {
        switch (this.type) {
            case 13: 
            case 14: {
                return true;
            }
        }
        return false;
    }

    public boolean isNumber() {
        short type = this.getItemType();
        switch (type) {
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 42: 
            case 200: 
            case 201: {
                return true;
            }
        }
        return false;
    }

    public int getIntegerValue() {
        return (int)this.f;
    }

    public double getDoubleValue() {
        return this.f;
    }

    public String getDoubleOrInteger() {
        return CSS_FLOAT_FORMAT.get().format(this.f);
    }

    private void setDoubleValue(double f) {
        this.f = f;
    }

    public String getDimensionUnitText() {
        switch (this.type) {
            case 13: 
            case 14: {
                return "";
            }
            case 23: {
                return "%";
            }
            case 15: {
                return "em";
            }
            case 200: {
                return "lem";
            }
            case 201: {
                return "rem";
            }
            case 16: {
                return "ex";
            }
            case 17: {
                return "px";
            }
            case 19: {
                return "cm";
            }
            case 20: {
                return "mm";
            }
            case 18: {
                return "in";
            }
            case 21: {
                return "pt";
            }
            case 22: {
                return "pc";
            }
            case 28: {
                return "deg";
            }
            case 30: {
                return "rad";
            }
            case 29: {
                return "grad";
            }
            case 31: {
                return "ms";
            }
            case 32: {
                return "s";
            }
            case 33: {
                return "Hz";
            }
            case 34: {
                return "kHz";
            }
            case 42: {
                return this.sdimension;
            }
        }
        throw new IllegalStateException("invalid dimension " + this.type);
    }

    public String getStringValue() {
        return this.s == null ? null : this.s.toString();
    }

    private void setStringValue(String str) {
        this.s = new StringInterpolationSequence(str);
    }

    public String getFunctionName() {
        return this.fname;
    }

    public ActualArgumentList getParameterList() {
        return this.params;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    @Override
    public String printState() {
        if (this.printState == null) {
            if (this.varNotResolved) {
                throw new ParseException("Variable was not resolved: " + this.simpleAsString(), this.uri, this.line, this.column);
            }
            this.printState = this.buildString(Node.PRINT_STRATEGY);
        }
        return this.printState;
    }

    public String toString() {
        String result = this.simpleAsString();
        if (result == null) {
            return "Lexical unit node [" + this.buildString(Node.TO_STRING_STRATEGY) + "]";
        }
        return result;
    }

    @Override
    public String unquotedString() {
        String result = this.printState();
        if (result.length() >= 2 && (result.charAt(0) == '\"' && result.charAt(result.length() - 1) == '\"' || result.charAt(0) == '\'' && result.charAt(result.length() - 1) == '\'')) {
            result = result.substring(1, result.length() - 1);
        }
        return result;
    }

    public LexicalUnitImpl divide(LexicalUnitImpl denominator) {
        if (denominator.type != 13 && denominator.type != 14 && this.type != denominator.type) {
            return new LexicalUnitImpl(this.uri, this.line, this.column, 35, this.printState() + '/' + denominator.printState());
        }
        LexicalUnitImpl copy = this.copyWithValue(this.getDoubleValue() / denominator.getDoubleValue());
        if (this.type == denominator.type) {
            copy.setLexicalUnitType((short)14);
        }
        return copy;
    }

    public LexicalUnitImpl add(LexicalUnitImpl another) {
        LexicalUnitImpl copy = this.copyWithValue(this.getDoubleValue() + another.getDoubleValue());
        copy.setLexicalUnitType(this.checkAndGetUnit(another));
        return copy;
    }

    public LexicalUnitImpl minus(LexicalUnitImpl another) {
        LexicalUnitImpl copy = this.copyWithValue(this.getDoubleValue() - another.getDoubleValue());
        copy.setLexicalUnitType(this.checkAndGetUnit(another));
        return copy;
    }

    public LexicalUnitImpl multiply(LexicalUnitImpl another) {
        LexicalUnitImpl copy = this.copyWithValue(this.getDoubleValue() * another.getDoubleValue());
        copy.setLexicalUnitType(this.checkAndGetUnit(another));
        return copy;
    }

    private ParseException createIncompatibleUnitsException(LexicalUnitImpl another) {
        String msg = "Incompatible units found in: '" + this.printState() + "' <> '" + another.printState() + "'\n" + new ParseException("", this).getMessage() + '\n';
        return new ParseException(msg, another);
    }

    public short checkAndGetUnit(LexicalUnitImpl another) {
        short thisType = this.type;
        short otherType = another.type;
        if (thisType == otherType) {
            return thisType;
        }
        switch (otherType) {
            case 13: 
            case 14: {
                return thisType == 13 ? otherType : thisType;
            }
            case 18: 
            case 19: 
            case 20: {
                switch (thisType) {
                    case 18: 
                    case 19: 
                    case 20: {
                        return thisType;
                    }
                }
            }
        }
        switch (thisType) {
            case 13: 
            case 14: {
                return otherType;
            }
        }
        throw this.createIncompatibleUnitsException(another);
    }

    public LexicalUnitImpl modulo(LexicalUnitImpl another) {
        if (!LexicalUnitImpl.checkLexicalUnitType(another, this.type, 13, 14)) {
            throw this.createIncompatibleUnitsException(another);
        }
        return this.copyWithValue(this.getIntegerValue() % another.getIntegerValue());
    }

    public LexicalUnitImpl copy() {
        LexicalUnitImpl copy = new LexicalUnitImpl(this.uri, this.line, this.column, this.type);
        copy.f = this.f;
        copy.s = this.s;
        copy.fname = this.fname;
        copy.sdimension = this.sdimension;
        copy.params = this.params;
        return copy;
    }

    public LexicalUnitImpl copyWithValue(double value) {
        LexicalUnitImpl result = this.copy();
        result.setDoubleValue(value);
        return result;
    }

    public String getSdimension() {
        return this.sdimension;
    }

    public static LexicalUnitImpl createVariable(String uri, int line, int column, String name) {
        return new LexicalUnitImpl(uri, line, column, 100, name);
    }

    public static LexicalUnitImpl createNull(String uri, int line, int column) {
        return new LexicalUnitImpl(uri, line, column, 110, "null");
    }

    public static LexicalUnitImpl createNumber(String uri, int line, int column, double v) {
        int i = (int)v;
        if (v == (double)i) {
            return new LexicalUnitImpl(uri, line, column, 13, i);
        }
        return new LexicalUnitImpl(uri, line, column, 14, v);
    }

    public static LexicalUnitImpl createInteger(String uri, int line, int column, int i) {
        return new LexicalUnitImpl(uri, line, column, 13, i);
    }

    public static LexicalUnitImpl createPercentage(String uri, int line, int column, double v) {
        if (Math.round(v * 100.0 * 100000.0) == (long)((int)v * 100) * 100000L) {
            v = (int)v;
        }
        return new LexicalUnitImpl(uri, line, column, 23, v);
    }

    static LexicalUnitImpl createEMS(String uri, int line, int column, double v) {
        return new LexicalUnitImpl(uri, line, column, 15, v);
    }

    static LexicalUnitImpl createLEM(String uri, int line, int column, double v) {
        return new LexicalUnitImpl(uri, line, column, 200, v);
    }

    static LexicalUnitImpl createREM(String uri, int line, int column, double v) {
        return new LexicalUnitImpl(uri, line, column, 201, v);
    }

    static LexicalUnitImpl createEXS(String uri, int line, int column, double v) {
        return new LexicalUnitImpl(uri, line, column, 16, v);
    }

    public static LexicalUnitImpl createPX(String uri, int line, int column, double v) {
        return new LexicalUnitImpl(uri, line, column, 17, v);
    }

    public static LexicalUnitImpl createCM(String uri, int line, int column, double v) {
        return new LexicalUnitImpl(uri, line, column, 19, v);
    }

    static LexicalUnitImpl createMM(String uri, int line, int column, double v) {
        return new LexicalUnitImpl(uri, line, column, 20, v);
    }

    static LexicalUnitImpl createIN(String uri, int line, int column, double v) {
        return new LexicalUnitImpl(uri, line, column, 18, v);
    }

    static LexicalUnitImpl createPT(String uri, int line, int column, double v) {
        return new LexicalUnitImpl(uri, line, column, 21, v);
    }

    static LexicalUnitImpl createPC(String uri, int line, int column, double v) {
        return new LexicalUnitImpl(uri, line, column, 22, v);
    }

    public static LexicalUnitImpl createDEG(String uri, int line, int column, double v) {
        return new LexicalUnitImpl(uri, line, column, 28, v);
    }

    static LexicalUnitImpl createRAD(String uri, int line, int column, double v) {
        return new LexicalUnitImpl(uri, line, column, 30, v);
    }

    static LexicalUnitImpl createGRAD(String uri, int line, int column, double v) {
        return new LexicalUnitImpl(uri, line, column, 29, v);
    }

    static LexicalUnitImpl createMS(String uri, int line, int column, double v) {
        if (v < 0.0) {
            throw new ParseException("Time values may not be negative", uri, line, column);
        }
        return new LexicalUnitImpl(uri, line, column, 31, v);
    }

    static LexicalUnitImpl createS(String uri, int line, int column, double v) {
        if (v < 0.0) {
            throw new ParseException("Time values may not be negative", uri, line, column);
        }
        return new LexicalUnitImpl(uri, line, column, 32, v);
    }

    static LexicalUnitImpl createHZ(String uri, int line, int column, double v) {
        if (v < 0.0) {
            throw new ParseException("Frequency values may not be negative", uri, line, column);
        }
        return new LexicalUnitImpl(uri, line, column, 33, v);
    }

    static LexicalUnitImpl createKHZ(String uri, int line, int column, double v) {
        if (v < 0.0) {
            throw new ParseException("Frequency values may not be negative", uri, line, column);
        }
        return new LexicalUnitImpl(uri, line, column, 34, v);
    }

    static LexicalUnitImpl createDimen(String uri, int line, int column, double v, String s) {
        return new LexicalUnitImpl(uri, line, column, 42, s, v);
    }

    static LexicalUnitImpl createInherit(String uri, int line, int column) {
        return new LexicalUnitImpl(uri, line, column, 12, "inherit");
    }

    public static LexicalUnitImpl createRawIdent(String uri, int line, int column, String s) {
        return new LexicalUnitImpl(uri, line, column, 35, s);
    }

    public static LexicalUnitImpl createIdent(String uri, int line, int column, String s) {
        return LexicalUnitImpl.createIdent(uri, line, column, new StringInterpolationSequence(s));
    }

    public static LexicalUnitImpl createIdent(String uri, int line, int column, StringInterpolationSequence s) {
        if ("null".equals(s.toString())) {
            return LexicalUnitImpl.createNull(uri, line, column);
        }
        return new LexicalUnitImpl(uri, line, column, 35, s);
    }

    public static LexicalUnitImpl createString(String uri, int line, int column, String s) {
        return LexicalUnitImpl.createString(uri, line, column, new StringInterpolationSequence(s));
    }

    public static LexicalUnitImpl createString(String uri, int line, int column, StringInterpolationSequence s) {
        return new LexicalUnitImpl(uri, line, column, 36, s);
    }

    public static LexicalUnitImpl createURL(String uri, int line, int column, StringInterpolationSequence s) {
        return new LexicalUnitImpl(uri, line, column, 24, s);
    }

    public static LexicalUnitImpl createRGBColor(String uri, int line, int column, ActualArgumentList params) {
        return new LexicalUnitImpl(uri, 27, line, column, "rgb", params);
    }

    public static LexicalUnitImpl createRect(String uri, int line, int column, ActualArgumentList params) {
        return new LexicalUnitImpl(uri, 38, line, column, "rect", params);
    }

    public static LexicalUnitImpl createFunction(String uri, int line, int column, String fname, ActualArgumentList params) {
        return new LexicalUnitImpl(uri, 41, line, column, fname, params);
    }

    public static LexicalUnitImpl createGetFunction(String uri, int line, int column, String fname) {
        return new LexicalUnitImpl(uri, 111, line, column, fname, null);
    }

    public static LexicalUnitImpl createParent(String uri, int line, int column) {
        return new LexicalUnitImpl(uri, line, column, 113);
    }

    public static boolean checkLexicalUnitType(SassListItem item, short ... lexicalUnitTypes) {
        if (!(item instanceof LexicalUnitImpl)) {
            return false;
        }
        short itemType = ((LexicalUnitImpl)item).type;
        for (short s : lexicalUnitTypes) {
            if (itemType != s) continue;
            return true;
        }
        return false;
    }

    public static LexicalUnitImpl createComma(String uri, int line, int column) {
        return new LexicalUnitImpl(uri, line, column, 0);
    }

    public static LexicalUnitImpl createSlash(String uri, int line, int column) {
        return new LexicalUnitImpl(uri, line, column, 4);
    }

    public static LexicalUnitImpl createAdd(String uri, int line, int column) {
        return new LexicalUnitImpl(uri, line, column, 1);
    }

    public static LexicalUnitImpl createMinus(String uri, int line, int column) {
        return new LexicalUnitImpl(uri, line, column, 2);
    }

    public static LexicalUnitImpl createMultiply(String uri, int line, int column) {
        return new LexicalUnitImpl(uri, line, column, 3);
    }

    public static LexicalUnitImpl createModulo(String uri, int line, int column) {
        return new LexicalUnitImpl(uri, line, column, 5);
    }

    public static LexicalUnitImpl createIdent(String s) {
        return new LexicalUnitImpl(null, 0, 0, 35, s);
    }

    public static LexicalUnitImpl createEquals(String uri, int line, int column) {
        return new LexicalUnitImpl(uri, line, column, 103);
    }

    public static LexicalUnitImpl createNotEqual(String uri, int line, int column) {
        return new LexicalUnitImpl(uri, line, column, 104);
    }

    public static LexicalUnitImpl createGreaterThan(String uri, int line, int column) {
        return new LexicalUnitImpl(uri, line, column, 8);
    }

    public static LexicalUnitImpl createGreaterThanOrEqualTo(String uri, int line, int column) {
        return new LexicalUnitImpl(uri, line, column, 10);
    }

    public static LexicalUnitImpl createLessThan(String uri, int line, int column) {
        return new LexicalUnitImpl(uri, line, column, 7);
    }

    public static LexicalUnitImpl createLessThanOrEqualTo(String uri, int line, int column) {
        return new LexicalUnitImpl(uri, line, column, 9);
    }

    public static LexicalUnitImpl createAnd(String uri, int line, int column) {
        return new LexicalUnitImpl(uri, line, column, 105);
    }

    public static LexicalUnitImpl createOr(String uri, int line, int column) {
        return new LexicalUnitImpl(uri, line, column, 106);
    }

    public boolean containsInterpolation() {
        return this.s != null && this.s.containsInterpolation();
    }

    @Override
    public SassListItem evaluateFunctionsAndExpressions(ScssContext context, boolean evaluateArithmetics) {
        switch (this.type) {
            case 100: {
                String stringValue = this.getStringValue();
                Variable var = context.getVariable(stringValue);
                if (var != null) {
                    return var.getExpr().evaluateFunctionsAndExpressions(context, evaluateArithmetics);
                }
                this.varNotResolved = true;
                break;
            }
            case 113: {
                BlockNode parentBlock = context.getParentBlock();
                return parentBlock != null ? new StringItem(parentBlock.getSelectors()) : LexicalUnitImpl.createNull(this.uri, this.line, this.column);
            }
            case 27: 
            case 41: {
                Object result;
                String functionName = this.fname;
                if ("calc".equals(functionName)) {
                    return LexicalUnitImpl.createFunction(this.uri, this.line, this.column, functionName, this.params.evaluateFunctionsAndExpressions(context, false));
                }
                SCSSFunctionGenerator generator = SCSSFunctionGenerator.getGenerator(functionName);
                LexicalUnitImpl copy = this;
                if (!"if".equals(functionName)) {
                    copy = LexicalUnitImpl.createFunction(this.uri, this.line, this.column, functionName, this.params.evaluateFunctionsAndExpressions(context, true));
                }
                if (generator == null && (result = copy.replaceCustomFunctions(context)) != null) {
                    return result;
                }
                if (generator == null) {
                    switch (functionName.toLowerCase()) {
                        case "blur": 
                        case "brightness": 
                        case "contrast": 
                        case "counters": 
                        case "hsl": 
                        case "hsla": 
                        case "linear-gradient": 
                        case "not ": 
                        case "radial-gradient": 
                        case "rgba": 
                        case "rotate": 
                        case "rotatex": 
                        case "rotatey": 
                        case "perspective": 
                        case "scale": 
                        case "scalex": 
                        case "scaley": 
                        case "translate": 
                        case "translate3d": 
                        case "translatey": 
                        case "translatex": 
                        case "translatez": 
                        case "url": 
                        case "var": {
                            break;
                        }
                        default: {
                            SCSSErrorHandler.get().warning("Unknown function: " + functionName);
                        }
                    }
                    return copy;
                }
                return generator.compute(context, copy);
            }
            default: {
                StringInterpolationSequence sis;
                StringInterpolationSequence s = this.s;
                if (s == null || !s.containsInterpolation() || (sis = s.replaceVariables(context)) == s) break;
                LexicalUnitImpl copy = this.copy();
                copy.s = sis;
                return copy;
            }
        }
        return this;
    }

    private SassListItem replaceCustomFunctions(ScssContext context) {
        FunctionDefNode functionDef = context.getFunctionDefinition(this.getFunctionName());
        if (functionDef != null) {
            return FunctionCall.evaluate(context, functionDef, this);
        }
        return null;
    }

    private String simpleAsString() {
        String text = null;
        switch (this.type) {
            case 100: {
                text = "$" + this.s;
                break;
            }
            case 110: {
                text = "";
                break;
            }
            case 0: {
                text = ",";
                break;
            }
            case 1: {
                text = "+";
                break;
            }
            case 2: {
                text = "-";
                break;
            }
            case 3: {
                text = "*";
                break;
            }
            case 4: {
                text = "/";
                break;
            }
            case 5: {
                text = "%";
                break;
            }
            case 6: {
                text = "^";
                break;
            }
            case 103: {
                text = "==";
                break;
            }
            case 104: {
                text = "!=";
                break;
            }
            case 107: {
                text = "not";
                break;
            }
            case 105: {
                text = "and";
                break;
            }
            case 106: {
                text = "or";
                break;
            }
            case 7: {
                text = "<";
                break;
            }
            case 8: {
                text = ">";
                break;
            }
            case 9: {
                text = "<=";
                break;
            }
            case 10: {
                text = "=>";
                break;
            }
            case 11: {
                text = "~";
                break;
            }
            case 12: {
                text = "inherit";
                break;
            }
            case 13: 
            case 14: {
                text = this.getDoubleOrInteger();
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 42: 
            case 200: 
            case 201: {
                text = this.getDoubleOrInteger() + this.getDimensionUnitText();
            }
        }
        return text;
    }

    @Override
    public String buildString(Node.BuildStringStrategy strategy) {
        String text = this.simpleAsString();
        if (text == null) {
            switch (this.type) {
                case 24: {
                    text = "url(" + this.getStringValue() + ")";
                    break;
                }
                case 27: {
                    int[] rgb = this.getRgb();
                    if (rgb != null) {
                        text = ColorUtil.rgbToColorString(rgb);
                        break;
                    }
                }
                case 25: 
                case 26: 
                case 38: 
                case 41: {
                    int[] rgb;
                    if (ColorUtil.isColor(this)) {
                        text = ColorUtil.rgbToColorString(ColorUtil.colorToRgb(this));
                        break;
                    }
                    if (ColorUtil.isRgba(this) || ColorUtil.isHsla(this)) {
                        double alpha = this.params.get(this.params.size() - 1).getContainedValue().getDoubleValue();
                        rgb = ColorUtil.colorToRgb(this);
                        if (rgb != null) {
                            if (alpha == 0.0 && rgb[0] == 0 && rgb[1] == 0 && rgb[2] == 0) {
                                text = "transparent";
                                break;
                            }
                            if (alpha == 1.0) {
                                text = ColorUtil.rgbToColorString(rgb);
                                break;
                            }
                            if (this.params.size() == 2 || ColorUtil.isHsla(this)) {
                                String alphaText = alpha == 0.0 ? "0" : CSS_FLOAT_FORMAT.get().format(alpha);
                                text = "rgba(" + rgb[0] + ", " + rgb[1] + ", " + rgb[2] + ", " + alphaText + ")";
                                break;
                            }
                        }
                    }
                    text = this.fname + "(" + this.params.buildString(strategy) + ")";
                    break;
                }
                case 111: {
                    text = "get-function(" + this.fname + ")";
                    break;
                }
                case 35: {
                    text = this.getStringValue();
                    break;
                }
                case 36: {
                    text = "\"" + this.getStringValue() + "\"";
                    break;
                }
                case 40: {
                    text = strategy.build(this.getParameterList());
                    break;
                }
                case 113: {
                    text = "&";
                    break;
                }
                default: {
                    text = "@unknown";
                }
            }
        }
        return text;
    }

    private int[] getRgb() {
        if (!(this.params.size() == 3 && LexicalUnitImpl.checkLexicalUnitType(this.params.get(0), 13) && LexicalUnitImpl.checkLexicalUnitType(this.params.get(1), 13) && LexicalUnitImpl.checkLexicalUnitType(this.params.get(2), 13))) {
            return null;
        }
        int red = ((LexicalUnitImpl)this.params.get(0)).getIntegerValue();
        int green = ((LexicalUnitImpl)this.params.get(1)).getIntegerValue();
        int blue = ((LexicalUnitImpl)this.params.get(2)).getIntegerValue();
        return new int[]{red, green, blue};
    }

    @Override
    public boolean containsArithmeticalOperator() {
        return false;
    }

    @Override
    public LexicalUnitImpl updateUrl(String prefix) {
        if (this.getItemType() == 24) {
            LexicalUnitImpl copy = this.copy();
            if (this.s.containsInterpolation()) {
                ArrayList<SassListItem> items = new ArrayList<SassListItem>();
                items.add(new StringItem(prefix));
                items.addAll(this.s.getItems());
                copy.s = new StringInterpolationSequence(items);
            } else {
                String path = this.getStringValue().replaceAll("^\"|\"$", "").replaceAll("^'|'$", "");
                if (!path.startsWith("/") && !path.contains(":")) {
                    path = prefix + path;
                    path = StringUtil.cleanPath(path);
                }
                copy.setStringValue(path);
            }
            return copy;
        }
        if (this.containsInterpolation()) {
            LexicalUnitImpl copy = this.copy();
            copy.s = this.s.updateUrl(prefix);
            return copy;
        }
        return this;
    }

    public boolean equals(Object o) {
        if (!(o instanceof LexicalUnitImpl)) {
            return false;
        }
        LexicalUnitImpl other = (LexicalUnitImpl)o;
        if (this.isNumber() && other.isNumber()) {
            if (!this.isUnitlessNumber() && !other.isUnitlessNumber() && this.getItemType() != other.getItemType()) {
                return false;
            }
            return this.getDoubleValue() == other.getDoubleValue() && this.getIntegerValue() == other.getIntegerValue();
        }
        if (this.getItemType() != other.getItemType()) {
            return false;
        }
        return this.printState().equals(other.printState());
    }

    public int hashCode() {
        return this.printState().hashCode();
    }

    @Override
    public LexicalUnitImpl getContainedValue() {
        return this;
    }
}

