/*
 * Decompiled with CFR 0.152.
 */
package com.inet.sass.parser;

import com.inet.sass.ScssContext;
import com.inet.sass.parser.LexicalUnitImpl;
import com.inet.sass.parser.ParseException;
import com.inet.sass.parser.SassListItem;
import com.inet.sass.parser.StringItem;
import com.inet.sass.tree.Node;

public class Interpolation
implements SassListItem {
    private int lineNumber;
    private int columnNumber;
    private SassListItem expression;
    private boolean evaluateArithmetics;

    public Interpolation(SassListItem expression, int line, int column) {
        this.expression = expression;
        this.lineNumber = line;
        this.columnNumber = column;
        this.evaluateArithmetics = expression.containsArithmeticalOperator();
    }

    private Interpolation(SassListItem expression, int line, int column, boolean evaluateArithmetics) {
        this.expression = expression;
        this.lineNumber = line;
        this.columnNumber = column;
        this.evaluateArithmetics = evaluateArithmetics;
    }

    @Override
    public short getItemType() {
        return 112;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public int getColumnNumber() {
        return this.columnNumber;
    }

    @Override
    public boolean containsArithmeticalOperator() {
        return this.evaluateArithmetics;
    }

    @Override
    public SassListItem evaluateFunctionsAndExpressions(ScssContext context, boolean evaluateArithmetics) {
        String str = this.expression.evaluateFunctionsAndExpressions(context, this.evaluateArithmetics).unquotedString();
        return new StringItem(str);
    }

    @Override
    public Interpolation updateUrl(String prefix) {
        return new Interpolation(this.expression.updateUrl(prefix), this.getLineNumber(), this.getColumnNumber(), this.evaluateArithmetics);
    }

    @Override
    public String printState() {
        return "#{" + this.expression.printState() + "}";
    }

    @Override
    public String buildString(Node.BuildStringStrategy strategy) {
        return this.printState();
    }

    public String toString() {
        return this.printState();
    }

    @Override
    public String unquotedString() {
        throw new ParseException("unquotedString() is not supported for interpolation");
    }

    @Override
    public LexicalUnitImpl getContainedValue() {
        throw new ParseException("getContainedValue() is not supported for interpolation");
    }

    public boolean equals(Object o) {
        if (!(o instanceof Interpolation)) {
            return false;
        }
        Interpolation other = (Interpolation)o;
        return this.expression.equals(other.expression);
    }

    public int hashCode() {
        return this.expression.hashCode();
    }
}

