/*
 * Decompiled with CFR 0.152.
 */
package com.inet.sass.parser;

import com.inet.sass.parser.ActualArgumentList;
import com.inet.sass.parser.ArgumentList;
import com.inet.sass.parser.ParseException;
import com.inet.sass.parser.SassListItem;
import com.inet.sass.parser.Variable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class FormalArgumentList
implements Iterable<Variable> {
    private ArrayList<Variable> arglist;
    private String variableArgumentName;

    public FormalArgumentList(Collection<Variable> args, boolean hasVariableArguments) {
        if (args != null) {
            this.arglist = new ArrayList<Variable>(args);
            if (hasVariableArguments) {
                if (this.arglist.size() == 0) {
                    throw new ParseException("Variable arguments are not allowed with an empty formal parameter list.");
                }
                this.variableArgumentName = this.arglist.get(args.size() - 1).getName();
            }
        } else {
            this.arglist = new ArrayList();
        }
    }

    public FormalArgumentList replaceFormalArguments(ActualArgumentList actualArgumentList, boolean checkForUnsetParameters) {
        ArrayList<Variable> result = FormalArgumentList.initializeArgumentList(this.arglist);
        List<Variable> unusedNamedActual = this.replaceNamedArguments(result, actualArgumentList);
        List<SassListItem> unusedUnnamedActual = this.replaceUnnamedAndDefaultArguments(result, actualArgumentList, checkForUnsetParameters);
        if (this.hasVariableArguments()) {
            ArgumentList varArgContents = new ArgumentList(actualArgumentList.getSeparator(), unusedUnnamedActual, unusedNamedActual);
            Variable varArg = new Variable(this.variableArgumentName, varArgContents);
            result.set(result.size() - 1, varArg);
        } else if (!unusedNamedActual.isEmpty() || !unusedUnnamedActual.isEmpty()) {
            throw new ParseException("Substitution error: some actual parameters were not used. Formal parameters: " + this + ", actual parameters: " + actualArgumentList, actualArgumentList);
        }
        return new FormalArgumentList(result, false);
    }

    private List<Variable> replaceNamedArguments(ArrayList<Variable> formalArguments, ActualArgumentList actualArguments) {
        ArrayList<Variable> unusedNamed = new ArrayList<Variable>();
        for (Variable actualArg : actualArguments.getNamedVariables()) {
            boolean actualUsed = false;
            for (Variable formalArg : formalArguments) {
                if (!formalArg.getName().equals(actualArg.getName()) || actualArg.getName().equals(this.variableArgumentName)) continue;
                if (formalArg.getExpr() != null) {
                    throw new ParseException("The named argument $" + formalArg.getName() + "appears more than once in the actual argument list: " + actualArguments, actualArguments);
                }
                actualUsed = true;
                formalArg.setExpr(actualArg.getExpr());
            }
            if (actualUsed) continue;
            if (!this.hasVariableArguments()) {
                throw new ParseException("There is no formal argument corresponding to the actual argument " + actualArg.getName() + " in the formal argument list " + this, actualArguments);
            }
            unusedNamed.add(actualArg);
        }
        return unusedNamed;
    }

    private List<SassListItem> replaceUnnamedAndDefaultArguments(ArrayList<Variable> formalArguments, ActualArgumentList actualArguments, boolean checkForUnsetParameters) {
        int actualIndex;
        int maxFormalIndex;
        int formalIndex = FormalArgumentList.getNextUnset(formalArguments, 0);
        int n = maxFormalIndex = this.hasVariableArguments() ? formalArguments.size() - 1 : formalArguments.size();
        for (actualIndex = 0; formalIndex < maxFormalIndex && actualIndex < actualArguments.size(); ++actualIndex) {
            formalArguments.get(formalIndex).setExpr(actualArguments.get(actualIndex));
            formalIndex = FormalArgumentList.getNextUnset(formalArguments, formalIndex + 1);
        }
        while (formalIndex < maxFormalIndex) {
            if (this.arglist.get(formalIndex).getExpr() == null && checkForUnsetParameters) {
                throw new ParseException("Argument substitution error: there is no value for the argument " + formalArguments.get(formalIndex).getName() + ". Formal arguments: " + this + ", actual arguments: " + actualArguments, actualArguments);
            }
            formalArguments.get(formalIndex).setExpr(this.arglist.get(formalIndex).getExpr());
            formalIndex = FormalArgumentList.getNextUnset(formalArguments, formalIndex + 1);
        }
        ArrayList<SassListItem> remainingUnnamed = FormalArgumentList.subList(actualArguments, actualIndex, actualArguments.size());
        return remainingUnnamed;
    }

    private static ArrayList<SassListItem> subList(ActualArgumentList list, int minIndex, int maxIndex) {
        ArrayList<SassListItem> result = new ArrayList<SassListItem>();
        for (int i = minIndex; i < maxIndex; ++i) {
            result.add(list.get(i));
        }
        return result;
    }

    private static int getNextUnset(ArrayList<Variable> named, int i) {
        while (i < named.size() && named.get(i).getExpr() != null) {
            ++i;
        }
        return i;
    }

    private static ArrayList<Variable> initializeArgumentList(List<Variable> namedParameters) {
        ArrayList<Variable> result = new ArrayList<Variable>();
        for (Variable var : namedParameters) {
            result.add(new Variable(var.getName(), null));
        }
        return result;
    }

    public boolean hasVariableArguments() {
        return this.variableArgumentName != null;
    }

    public boolean isEmpty() {
        return this.arglist.isEmpty();
    }

    @Override
    public Iterator<Variable> iterator() {
        return this.arglist.iterator();
    }

    public int size() {
        return this.arglist.size();
    }

    public Variable get(int i) {
        return this.arglist.get(i);
    }

    public List<Variable> getArguments() {
        return this.arglist;
    }

    public String toString() {
        String result = "FormalArgumentList[";
        for (int i = 0; i < this.arglist.size(); ++i) {
            Variable item = this.arglist.get(i);
            result = result + "$" + item.getName() + ": ";
            result = item.getExpr() == null ? result + "null" : result + item.getExpr().printState();
            if (i >= this.arglist.size() - 1) continue;
            result = result + ", ";
        }
        result = result + "]";
        return result;
    }

    public FormalArgumentList updateUrl(String prefix) {
        ArrayList<Variable> newArgList = new ArrayList<Variable>(this.arglist.size());
        for (Variable var : this.getArguments()) {
            if (var.getExpr() != null) {
                newArgList.add(new Variable(var.getName(), var.getExpr().updateUrl(prefix), var.isGuarded()));
                continue;
            }
            newArgList.add(var);
        }
        return new FormalArgumentList(newArgList, this.variableArgumentName != null);
    }
}

