/*
 * Decompiled with CFR 0.152.
 */
package com.inet.sass.parser;

import com.inet.sass.ScssContext;
import com.inet.sass.parser.SassList;
import com.inet.sass.parser.SassListItem;
import com.inet.sass.parser.Variable;
import com.inet.sass.tree.Node;
import java.util.ArrayList;
import java.util.List;

public class ArgumentList
extends SassList {
    private List<Variable> namedVariables = new ArrayList<Variable>();

    public ArgumentList(SassList list) {
        super(list.getSeparator(), list.getItems());
    }

    public ArgumentList(SassList.Separator separator, List<SassListItem> list, List<Variable> named) {
        super(separator, list);
        this.namedVariables = named;
    }

    public ArgumentList(SassList.Separator sep, SassListItem ... items) {
        super(sep, items);
    }

    public ArgumentList(SassList.Separator separator, List<SassListItem> newParamValues) {
        super(separator, newParamValues);
    }

    public List<Variable> getNamedVariables() {
        return this.namedVariables;
    }

    @Override
    public ArgumentList evaluateFunctionsAndExpressions(ScssContext context, boolean evaluateArithmetics) {
        ArrayList<SassListItem> list = new ArrayList<SassListItem>();
        for (SassListItem item : this) {
            list.add(item.evaluateFunctionsAndExpressions(context, evaluateArithmetics));
        }
        ArrayList<Variable> named = new ArrayList<Variable>();
        for (Variable var : this.namedVariables) {
            named.add(new Variable(var.getName(), var.getExpr().evaluateFunctionsAndExpressions(context, evaluateArithmetics), var.isGuarded()));
        }
        return new ArgumentList(this.getSeparator(), list, named);
    }

    protected SassList.Separator getSeparator(SassListItem expr) {
        SassList lastList;
        if (expr instanceof SassList && (lastList = (SassList)expr).size() > 1) {
            return lastList.getSeparator();
        }
        return SassList.Separator.COMMA;
    }

    @Override
    public String toString() {
        String unnamed = this.buildString(Node.PRINT_STRATEGY);
        String named = this.namedAsString();
        if (unnamed.length() > 0 && named.length() > 0) {
            unnamed = unnamed + ", ";
        }
        return "ArgumentList [" + unnamed + named + "]";
    }

    private String namedAsString() {
        String result = "";
        for (int i = 0; i < this.namedVariables.size(); ++i) {
            Variable named = this.namedVariables.get(i);
            String contents = named.getExpr() == null ? "null" : named.getExpr().buildString(Node.PRINT_STRATEGY);
            result = result + "$" + named.getName() + ": " + contents;
            if (i >= this.namedVariables.size() - 1) continue;
            result = result + ", ";
        }
        return result;
    }

    @Override
    public ArgumentList updateUrl(String prefix) {
        SassList newUnnamedVariables = super.updateUrl(prefix);
        ArrayList<Variable> newNamedVariables = new ArrayList<Variable>(this.namedVariables.size());
        for (Variable var : this.namedVariables) {
            if (var.getExpr() != null) {
                SassListItem newExpr = var.getExpr().updateUrl(prefix);
                newNamedVariables.add(new Variable(var.getName(), newExpr, var.isGuarded()));
                continue;
            }
            newNamedVariables.add(var);
        }
        return new ArgumentList(this.getSeparator(), newUnnamedVariables.getItems(), newNamedVariables);
    }
}

