/*
 * Decompiled with CFR 0.152.
 */
package com.inet.sass.parser;

import com.inet.sass.ScssContext;
import com.inet.sass.parser.ArgumentList;
import com.inet.sass.parser.SassList;
import com.inet.sass.parser.SassListItem;
import com.inet.sass.parser.Variable;
import com.inet.sass.tree.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ActualArgumentList {
    private ArgumentList arglist;
    private SassListItem variableArgument;

    public ActualArgumentList(ArgumentList list, SassListItem variableArgument) {
        this.arglist = list;
        this.variableArgument = variableArgument;
    }

    public ActualArgumentList(SassList.Separator separator, List<SassListItem> list, List<Variable> named, SassListItem variableArgument) {
        this.arglist = new ArgumentList(separator, list, named);
        this.variableArgument = variableArgument;
    }

    public ActualArgumentList(SassList.Separator sep, SassListItem ... items) {
        this.arglist = new ArgumentList(sep, items);
    }

    public ActualArgumentList(SassList.Separator separator, List<SassListItem> newParamValues) {
        this.arglist = new ArgumentList(separator, newParamValues);
    }

    public ActualArgumentList(SassList.Separator separator, Collection<Variable> args, boolean hasVariableArguments) {
        ArrayList<SassListItem> unnamed = new ArrayList<SassListItem>();
        ArrayList<Variable> named = new ArrayList<Variable>();
        if (args != null) {
            for (Variable arg : args) {
                if (arg.getName() == null) {
                    unnamed.add(arg.getExpr());
                    continue;
                }
                named.add(arg.copy());
            }
        }
        SassListItem varArg = null;
        if (hasVariableArguments) {
            varArg = (SassListItem)unnamed.get(unnamed.size() - 1);
            unnamed.remove(unnamed.size() - 1);
        }
        this.arglist = new ArgumentList(separator, unnamed, named);
        this.variableArgument = varArg;
    }

    public ActualArgumentList expandVariableArguments() {
        SassListItem variableArgument = this.variableArgument;
        if (variableArgument != null) {
            ArrayList<SassListItem> unnamedArgs = new ArrayList<SassListItem>(this.arglist.getItems());
            ArrayList<Variable> namedArgs = new ArrayList<Variable>(this.arglist.getNamedVariables());
            if (variableArgument instanceof SassList) {
                SassList lastList = (SassList)variableArgument;
                for (SassListItem item : lastList) {
                    SassList map;
                    if (item.getClass() == SassList.class && (map = (SassList)item).getSeparator() == SassList.Separator.COLON) {
                        namedArgs.add(new Variable(map.get(0).unquotedString(), map.get(1)));
                        continue;
                    }
                    unnamedArgs.add(item);
                }
            }
            if (variableArgument.getClass() == ArgumentList.class) {
                for (Variable namedVar : ((ArgumentList)variableArgument).getNamedVariables()) {
                    namedArgs.add(namedVar.copy());
                }
            }
            return new ActualArgumentList(this.arglist.getSeparator(variableArgument), unnamedArgs, namedArgs, null);
        }
        return this;
    }

    public ActualArgumentList evaluateFunctionsAndExpressions(ScssContext context, boolean evaluateArithmetics) {
        ArgumentList newArgList = this.arglist.evaluateFunctionsAndExpressions(context, evaluateArithmetics);
        SassListItem newVarArg = null;
        if (this.hasVariableArguments()) {
            newVarArg = this.variableArgument.evaluateFunctionsAndExpressions(context, evaluateArithmetics);
        }
        return new ActualArgumentList(newArgList, newVarArg);
    }

    public boolean hasVariableArguments() {
        return this.variableArgument != null;
    }

    public String buildString(Node.BuildStringStrategy strategy) {
        return this.arglist.buildString(strategy);
    }

    public String printState() {
        return this.arglist.printState();
    }

    public String toString() {
        String result = "Actual argument list [" + this.arglist.toString();
        if (this.variableArgument != null) {
            result = result + ", variable argument: " + this.variableArgument.toString();
        }
        result = result + "]";
        return result;
    }

    public int size() {
        return this.arglist.size();
    }

    public SassListItem get(int i) {
        return this.arglist.get(i);
    }

    public SassList.Separator getSeparator() {
        return this.arglist.getSeparator();
    }

    public List<Variable> getNamedVariables() {
        return this.arglist.getNamedVariables();
    }

    public ActualArgumentList updateUrl(String prefix) {
        ArgumentList newArgList = this.arglist.updateUrl(prefix);
        SassListItem newVariableArgument = this.variableArgument;
        if (this.variableArgument != null) {
            newVariableArgument = this.variableArgument.updateUrl(prefix);
        }
        return new ActualArgumentList(newArgList, newVariableArgument);
    }
}

