/*
 * Decompiled with CFR 0.152.
 */
package com.inet.sass.handler;

import com.inet.sass.ScssStylesheet;
import com.inet.sass.parser.ActualArgumentList;
import com.inet.sass.parser.FormalArgumentList;
import com.inet.sass.parser.MediaList;
import com.inet.sass.parser.SassListItem;
import com.inet.sass.parser.StringInterpolationSequence;
import com.inet.sass.selector.Selector;
import com.inet.sass.tree.BlockNode;
import com.inet.sass.tree.CommentNode;
import com.inet.sass.tree.ContentNode;
import com.inet.sass.tree.ExtendNode;
import com.inet.sass.tree.FontFaceNode;
import com.inet.sass.tree.FunctionDefNode;
import com.inet.sass.tree.ImportNode;
import com.inet.sass.tree.KeyframeSelectorNode;
import com.inet.sass.tree.KeyframesNode;
import com.inet.sass.tree.MediaNode;
import com.inet.sass.tree.MessageNode;
import com.inet.sass.tree.MixinDefNode;
import com.inet.sass.tree.MixinNode;
import com.inet.sass.tree.NestPropertiesNode;
import com.inet.sass.tree.Node;
import com.inet.sass.tree.ReturnNode;
import com.inet.sass.tree.RuleNode;
import com.inet.sass.tree.SimpleNode;
import com.inet.sass.tree.VariableNode;
import com.inet.sass.tree.controldirective.EachDefNode;
import com.inet.sass.tree.controldirective.ElseNode;
import com.inet.sass.tree.controldirective.ForNode;
import com.inet.sass.tree.controldirective.IfElseDefNode;
import com.inet.sass.tree.controldirective.IfNode;
import com.inet.sass.tree.controldirective.WhileNode;
import java.util.List;
import java.util.Stack;

public class SCSSDocumentHandler {
    private final ScssStylesheet styleSheet;
    Stack<Node> nodeStack = new Stack();

    public SCSSDocumentHandler(ScssStylesheet styleSheet) {
        this.styleSheet = styleSheet;
        this.nodeStack.push(styleSheet);
    }

    public ScssStylesheet getStyleSheet() {
        return this.styleSheet;
    }

    public void variable(String name, SassListItem value, boolean guarded) {
        VariableNode node = new VariableNode(name, value, guarded);
        this.nodeStack.peek().appendChild(node);
    }

    public void debugDirective(SassListItem message) {
        MessageNode node = new MessageNode(message, MessageNode.MessageLevel.debug);
        this.nodeStack.peek().appendChild(node);
    }

    public void warnDirective(SassListItem message) {
        MessageNode node = new MessageNode(message, MessageNode.MessageLevel.warn);
        this.nodeStack.peek().appendChild(node);
    }

    public void errorDirective(SassListItem message) {
        MessageNode node = new MessageNode(message, MessageNode.MessageLevel.error);
        this.nodeStack.peek().appendChild(node);
    }

    public void startForDirective(String var, SassListItem from, SassListItem to, boolean exclusive) {
        ForNode node = new ForNode(var, from, to, exclusive);
        this.nodeStack.peek().appendChild(node);
        this.nodeStack.push(node);
    }

    public void endForDirective() {
        this.nodeStack.pop();
    }

    public void startEachDirective(List<String> variables, SassListItem list) {
        EachDefNode node = new EachDefNode(variables, list);
        this.nodeStack.peek().appendChild(node);
        this.nodeStack.push(node);
    }

    public void endEachDirective() {
        this.nodeStack.pop();
    }

    public void startWhileDirective(SassListItem condition) {
        WhileNode node = new WhileNode(condition);
        this.nodeStack.peek().appendChild(node);
        this.nodeStack.push(node);
    }

    public void endWhileDirective() {
        this.nodeStack.pop();
    }

    public void comment(String text) {
        CommentNode node = new CommentNode(text);
        this.nodeStack.peek().appendChild(node);
    }

    public void startMedia(String uri, int line, int column, MediaList media) {
        MediaNode node = new MediaNode(uri, line, column, media);
        this.nodeStack.peek().appendChild(node);
        this.nodeStack.push(node);
    }

    public void endMedia() {
        this.nodeStack.pop();
    }

    public void startFontFace() {
        FontFaceNode node = new FontFaceNode();
        this.nodeStack.peek().appendChild(node);
        this.nodeStack.push(node);
    }

    public void endFontFace() {
        this.nodeStack.pop();
    }

    public void startSelector(String uri, int line, int column, List<Selector> selectors) {
        BlockNode node = new BlockNode(uri, line, column, selectors);
        this.nodeStack.peek().appendChild(node);
        this.nodeStack.push(node);
    }

    public void endSelector() {
        this.nodeStack.pop();
    }

    public void property(StringInterpolationSequence name, SassListItem value, boolean important, String comment) {
        RuleNode node = new RuleNode(name, value, important, comment);
        this.nodeStack.peek().appendChild(node);
    }

    public void extendDirective(List<Selector> list, boolean optional) {
        ExtendNode node = new ExtendNode(list, optional);
        this.nodeStack.peek().appendChild(node);
    }

    public void startNestedProperties(StringInterpolationSequence name) {
        NestPropertiesNode node = new NestPropertiesNode(name);
        this.nodeStack.peek().appendChild(node);
        this.nodeStack.push(node);
    }

    public void endNestedProperties() {
        this.nodeStack.pop();
    }

    public void startMixinDirective(String name, FormalArgumentList args) {
        MixinDefNode node = new MixinDefNode(name.trim(), args);
        this.nodeStack.peek().appendChild(node);
        this.nodeStack.push(node);
    }

    public void endMixinDirective() {
        this.nodeStack.pop();
    }

    public void startFunctionDirective(String name, FormalArgumentList args) {
        FunctionDefNode node = new FunctionDefNode(name.trim(), args);
        this.nodeStack.peek().appendChild(node);
        this.nodeStack.push(node);
    }

    public void endFunctionDirective() {
        this.nodeStack.pop();
    }

    public void importStyle(String uri, MediaList media, boolean isURL) {
        ImportNode node = new ImportNode(uri, media, isURL);
        this.nodeStack.peek().appendChild(node);
    }

    public void startIfElseDirective() {
        IfElseDefNode node = new IfElseDefNode();
        this.nodeStack.peek().appendChild(node);
        this.nodeStack.push(node);
    }

    public void ifDirective(SassListItem evaluator) {
        if (this.nodeStack.peek() instanceof IfNode) {
            this.nodeStack.pop();
        }
        IfNode node = new IfNode(evaluator);
        this.nodeStack.peek().appendChild(node);
        this.nodeStack.push(node);
    }

    public void elseDirective() {
        if (this.nodeStack.peek() instanceof IfNode) {
            this.nodeStack.pop();
        }
        ElseNode node = new ElseNode();
        this.nodeStack.peek().appendChild(node);
        this.nodeStack.push(node);
    }

    public void endIfElseDirective() {
        if (this.nodeStack.peek() instanceof ElseNode || this.nodeStack.peek() instanceof IfNode) {
            this.nodeStack.pop();
        }
        this.nodeStack.pop();
    }

    public void unrecognizedRule(String text) {
        SimpleNode node = new SimpleNode(text);
        this.nodeStack.peek().appendChild(node);
    }

    public void startKeyFrames(String keyframeName, StringInterpolationSequence animationName) {
        KeyframesNode node = new KeyframesNode(keyframeName, animationName);
        this.nodeStack.peek().appendChild(node);
        this.nodeStack.push(node);
    }

    public void endKeyFrames() {
        this.nodeStack.pop();
    }

    public void startKeyframeSelector(String selector) {
        KeyframeSelectorNode node = new KeyframeSelectorNode(selector);
        this.nodeStack.peek().appendChild(node);
        this.nodeStack.push(node);
    }

    public void endKeyframeSelector() {
        this.nodeStack.pop();
    }

    public void contentDirective() {
        ContentNode node = new ContentNode();
        this.nodeStack.peek().appendChild(node);
    }

    public void returnDirective(SassListItem expr) {
        ReturnNode node = new ReturnNode(expr);
        this.nodeStack.peek().appendChild(node);
    }

    public void startInclude(String uri, int line, int column, String name, ActualArgumentList args) {
        MixinNode node = new MixinNode(uri, line, column, name, args);
        this.nodeStack.peek().appendChild(node);
        this.nodeStack.push(node);
    }

    public void endInclude() {
        this.nodeStack.pop();
    }
}

