/*
 * Decompiled with CFR 0.152.
 */
package com.inet.sass.function;

import com.inet.sass.ScssContext;
import com.inet.sass.function.AbstractFunctionGenerator;
import com.inet.sass.parser.FormalArgumentList;
import com.inet.sass.parser.LexicalUnitImpl;
import com.inet.sass.parser.SassList;
import com.inet.sass.parser.SassListItem;
import com.inet.sass.util.ColorUtil;

class TypeOfFunctionGenerator
extends AbstractFunctionGenerator {
    private static String[] argumentNames = new String[]{"value"};

    TypeOfFunctionGenerator() {
        super(TypeOfFunctionGenerator.createArgumentList(argumentNames, false), "type-of");
    }

    @Override
    protected SassListItem computeForArgumentList(ScssContext context, LexicalUnitImpl function, FormalArgumentList actualArguments) {
        SassListItem param = TypeOfFunctionGenerator.getParam(actualArguments, 0);
        String type = "string";
        switch (param.getItemType()) {
            case 115: {
                SassListItem first;
                type = "list";
                SassList list = (SassList)param;
                if (list.size() <= 0 || (first = list.get(0)).getClass() != SassList.class || ((SassList)first).getSeparator() != SassList.Separator.COLON) break;
                type = "map";
                break;
            }
            case 110: {
                type = "null";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 42: 
            case 200: 
            case 201: {
                type = "number";
                break;
            }
            case 35: {
                String str = ((LexicalUnitImpl)param).getStringValue();
                if ("true".equals(str) || "false".equals(str)) {
                    type = "bool";
                    break;
                }
                if (!ColorUtil.isColorName(str) && !ColorUtil.isHexColor(str)) break;
                type = "color";
                break;
            }
            case 27: {
                type = "color";
                break;
            }
            case 41: {
                String str;
                switch (str = ((LexicalUnitImpl)param).getFunctionName()) {
                    case "rgb": 
                    case "rgba": 
                    case "hsl": 
                    case "hsla": {
                        type = "color";
                    }
                }
            }
        }
        return LexicalUnitImpl.createRawIdent(function.getUri(), function.getLineNumber(), function.getColumnNumber(), type);
    }
}

