/*
 * Decompiled with CFR 0.152.
 */
package com.inet.sass.function;

import com.inet.sass.ScssContext;
import com.inet.sass.function.AbstractFunctionGenerator;
import com.inet.sass.parser.ActualArgumentList;
import com.inet.sass.parser.FormalArgumentList;
import com.inet.sass.parser.LexicalUnitImpl;
import com.inet.sass.parser.ParseException;
import com.inet.sass.parser.SassListItem;
import com.inet.sass.util.ColorUtil;

class TransparencyModificationFunctionGenerator
extends AbstractFunctionGenerator {
    private static String[] argumentNames = new String[]{"color", "amount"};

    TransparencyModificationFunctionGenerator() {
        super(TransparencyModificationFunctionGenerator.createArgumentList(argumentNames, false), "transparentize", "fade-out", "opacify", "fade-in");
    }

    @Override
    protected SassListItem computeForArgumentList(ScssContext context, LexicalUnitImpl function, FormalArgumentList actualArguments) {
        this.checkParameters(function, actualArguments);
        double factor = 1.0;
        if ("fade-out".equals(function.getFunctionName()) || "transparentize".equals(function.getFunctionName())) {
            factor = -1.0;
        }
        double amount = TransparencyModificationFunctionGenerator.getParam(actualArguments, "amount").getContainedValue().getDoubleValue();
        LexicalUnitImpl color = (LexicalUnitImpl)TransparencyModificationFunctionGenerator.getParam(actualArguments, "color");
        double opacity = 1.0;
        boolean rgba = ColorUtil.isRgba(color);
        boolean hsla = ColorUtil.isHsla(color);
        boolean hsl = ColorUtil.isHslColor(color);
        if (rgba || hsla) {
            ActualArgumentList colorComponents = color.getParameterList();
            int lastIndex = colorComponents.size() - 1;
            opacity = this.getDouble(colorComponents, lastIndex);
        }
        opacity += factor * amount;
        opacity = Math.min(1.0, Math.max(0.0, opacity));
        if (hsl || hsla) {
            return ColorUtil.createHslaOrHslColor(ColorUtil.colorToHsl(color), opacity, function.getLineNumber(), function.getColumnNumber());
        }
        return ColorUtil.createRgbaOrHexColor(ColorUtil.colorToRgb(color), opacity, function.getLineNumber(), function.getColumnNumber());
    }

    private void checkParameters(LexicalUnitImpl function, FormalArgumentList args) {
        SassListItem color = TransparencyModificationFunctionGenerator.getParam(args, 0);
        if (!(color instanceof LexicalUnitImpl) || !ColorUtil.isColor(color.getContainedValue()) && !ColorUtil.isRgba(color.getContainedValue()) && !ColorUtil.isHsla(color.getContainedValue())) {
            throw new ParseException("The function " + function.getFunctionName() + " requires a valid color as its first parameter", function);
        }
        SassListItem amountItem = TransparencyModificationFunctionGenerator.getParam(args, 1);
        if (!(amountItem instanceof LexicalUnitImpl) || !LexicalUnitImpl.checkLexicalUnitType(amountItem, 13, 14)) {
            throw new ParseException("The function " + function.getFunctionName() + " requires a number as its second parameter", function);
        }
        double amount = amountItem.getContainedValue().getDoubleValue();
        if (amount < 0.0 || amount > 1.0) {
            throw new ParseException("The function " + function.getFunctionName() + " requires a number in the range [0, 1] as its second parameter", function);
        }
    }

    private double getDouble(ActualArgumentList params, int i) {
        return params.get(i).getContainedValue().getDoubleValue();
    }
}

