/*
 * Decompiled with CFR 0.152.
 */
package com.inet.sass.function;

import com.inet.sass.ScssContext;
import com.inet.sass.function.AbstractFunctionGenerator;
import com.inet.sass.parser.FormalArgumentList;
import com.inet.sass.parser.LexicalUnitImpl;
import com.inet.sass.parser.ParseException;
import com.inet.sass.parser.SassListItem;

class StrSliceFunctionGenerator
extends AbstractFunctionGenerator {
    StrSliceFunctionGenerator() {
        super(StrSliceFunctionGenerator.createArgumentList(new String[]{"string", "start-at", "end-at"}, false), "str-slice");
    }

    @Override
    protected boolean checkForUnsetParameters() {
        return false;
    }

    @Override
    protected SassListItem computeForArgumentList(ScssContext context, LexicalUnitImpl function, FormalArgumentList actualArguments) {
        SassListItem strParam = StrSliceFunctionGenerator.getParam(actualArguments, "string");
        if (strParam == null) {
            throw new ParseException("Error in parameter 'string' of function " + function.getFunctionName(), function);
        }
        SassListItem startParam = StrSliceFunctionGenerator.getParam(actualArguments, "start-at");
        if (!(strParam instanceof LexicalUnitImpl)) {
            throw new ParseException("Error in parameter 'start-at' of function " + function.getFunctionName(), function);
        }
        SassListItem endParam = StrSliceFunctionGenerator.getParam(actualArguments, "end-at");
        String str = strParam.unquotedString();
        int length = str.length();
        int start = ((LexicalUnitImpl)startParam).getIntegerValue() - 1;
        if (start < 0) {
            start = length + start + 1;
        }
        start = Math.min(start, length);
        int end = endParam instanceof LexicalUnitImpl ? ((LexicalUnitImpl)endParam).getIntegerValue() : length;
        if (end < 0) {
            end = length + end + 1;
        }
        end = Math.min(Math.max(start, end), length);
        return LexicalUnitImpl.createString(function.getUri(), function.getLineNumber(), function.getColumnNumber(), str.substring(start, end));
    }
}

